<?php declare(strict_types=1);
/**
 * SAFETReimbursementEvent.
 *
 * PHP version 7.4
 *
 * @category Class
 *
 * @author   OpenAPI Generator team
 *
 * @link     https://openapi-generator.tech
 */

/**
 * Selling Partner API for Finances.
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AmazonPHP\SellingPartner\Model\Finances;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * This class was auto-generated by https://github.com/OpenAPITools/openapi-generator/.
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh.
 *
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SAFETReimbursementEvent implements \ArrayAccess, \JsonSerializable, ModelInterface
{
    public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static string $openAPIModelName = 'SAFETReimbursementEvent';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'posted_date' => '\DateTime',
        'safet_claim_id' => 'string',
        'reimbursed_amount' => '\AmazonPHP\SellingPartner\Model\Finances\Currency',
        'reason_code' => 'string',
        'safet_reimbursement_item_list' => '\AmazonPHP\SellingPartner\Model\Finances\SAFETReimbursementItem[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     * @phpstan-var array<string, string|null>
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'posted_date' => 'date-time',
        'safet_claim_id' => null,
        'reimbursed_amount' => null,
        'reason_code' => null,
        'safet_reimbursement_item_list' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'posted_date' => 'PostedDate',
        'safet_claim_id' => 'SAFETClaimId',
        'reimbursed_amount' => 'ReimbursedAmount',
        'reason_code' => 'ReasonCode',
        'safet_reimbursement_item_list' => 'SAFETReimbursementItemList',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'posted_date' => 'setPostedDate',
        'safet_claim_id' => 'setSafetClaimId',
        'reimbursed_amount' => 'setReimbursedAmount',
        'reason_code' => 'setReasonCode',
        'safet_reimbursement_item_list' => 'setSafetReimbursementItemList',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'posted_date' => 'getPostedDate',
        'safet_claim_id' => 'getSafetClaimId',
        'reimbursed_amount' => 'getReimbursedAmount',
        'reason_code' => 'getReasonCode',
        'safet_reimbursement_item_list' => 'getSafetReimbursementItemList',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['posted_date'] = $data['posted_date'] ?? null;
        $this->container['safet_claim_id'] = $data['safet_claim_id'] ?? null;
        $this->container['reimbursed_amount'] = $data['reimbursed_amount'] ?? null;
        $this->container['reason_code'] = $data['reason_code'] ?? null;
        $this->container['safet_reimbursement_item_list'] = $data['safet_reimbursement_item_list'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return string[]
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return null[]|string[]
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return string[]
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return string[]
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return string[]
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['reimbursed_amount'] !== null) {
            $this->container['reimbursed_amount']->validate();
        }
    }

    /**
     * Gets posted_date.
     *
     * @return null|\DateTime|\DateTimeImmutable
     */
    public function getPostedDate() : ?\DateTimeInterface
    {
        return $this->container['posted_date'];
    }

    /**
     * Sets posted_date.
     *
     * @param \DateTime|\DateTimeImmutable $posted_date posted_date
     */
    public function setPostedDate(\DateTimeInterface $posted_date) : self
    {
        $this->container['posted_date'] = $posted_date;

        return $this;
    }

    /**
     * Gets safet_claim_id.
     */
    public function getSafetClaimId() : ?string
    {
        return $this->container['safet_claim_id'];
    }

    /**
     * Sets safet_claim_id.
     *
     * @param null|string $safet_claim_id a SAFE-T claim identifier
     */
    public function setSafetClaimId(?string $safet_claim_id) : self
    {
        $this->container['safet_claim_id'] = $safet_claim_id;

        return $this;
    }

    /**
     * Gets reimbursed_amount.
     */
    public function getReimbursedAmount() : ?Currency
    {
        return $this->container['reimbursed_amount'];
    }

    /**
     * Sets reimbursed_amount.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\Finances\Currency $reimbursed_amount reimbursed_amount
     */
    public function setReimbursedAmount(?Currency $reimbursed_amount) : self
    {
        $this->container['reimbursed_amount'] = $reimbursed_amount;

        return $this;
    }

    /**
     * Gets reason_code.
     */
    public function getReasonCode() : ?string
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code.
     *
     * @param null|string $reason_code indicates why the seller was reimbursed
     */
    public function setReasonCode(?string $reason_code) : self
    {
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets safet_reimbursement_item_list.
     *
     * @return null|\AmazonPHP\SellingPartner\Model\Finances\SAFETReimbursementItem[]
     */
    public function getSafetReimbursementItemList() : ?array
    {
        return $this->container['safet_reimbursement_item_list'];
    }

    /**
     * Sets safet_reimbursement_item_list.
     *
     * @param null|\AmazonPHP\SellingPartner\Model\Finances\SAFETReimbursementItem[] $safet_reimbursement_item_list a list of SAFETReimbursementItems
     */
    public function setSafetReimbursementItemList(?array $safet_reimbursement_item_list) : self
    {
        $this->container['safet_reimbursement_item_list'] = $safet_reimbursement_item_list;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed $value Value to be set
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
