<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\WarehousingAndDistribution;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for Amazon Warehousing and Distribution.
 *
 * The Selling Partner API for Amazon Warehousing and Distribution (AWD) provides programmatic access to information about AWD shipments and inventory.
 *
 * The version of the OpenAPI document: 2024-05-09
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class InboundShipmentSummary implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'InboundShipmentSummary';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'created_at' => '\DateTimeInterface',
        'external_reference_id' => 'string',
        'order_id' => 'string',
        'shipment_id' => 'string',
        'shipment_status' => '\AmazonPHP\SellingPartner\Model\WarehousingAndDistribution\InboundShipmentStatus',
        'updated_at' => '\DateTimeInterface',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'created_at' => 'date-time',
        'external_reference_id' => null,
        'order_id' => null,
        'shipment_id' => null,
        'shipment_status' => null,
        'updated_at' => 'date-time',
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'created_at' => 'createdAt',
        'external_reference_id' => 'externalReferenceId',
        'order_id' => 'orderId',
        'shipment_id' => 'shipmentId',
        'shipment_status' => 'shipmentStatus',
        'updated_at' => 'updatedAt',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'created_at' => 'setCreatedAt',
        'external_reference_id' => 'setExternalReferenceId',
        'order_id' => 'setOrderId',
        'shipment_id' => 'setShipmentId',
        'shipment_status' => 'setShipmentStatus',
        'updated_at' => 'setUpdatedAt',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'created_at' => 'getCreatedAt',
        'external_reference_id' => 'getExternalReferenceId',
        'order_id' => 'getOrderId',
        'shipment_id' => 'getShipmentId',
        'shipment_status' => 'getShipmentStatus',
        'updated_at' => 'getUpdatedAt',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['external_reference_id'] = $data['external_reference_id'] ?? null;
        $this->container['order_id'] = $data['order_id'] ?? null;
        $this->container['shipment_id'] = $data['shipment_id'] ?? null;
        $this->container['shipment_status'] = $data['shipment_status'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['order_id'] === null) {
            throw new AssertionException("'order_id' can't be null");
        }

        if ((\mb_strlen((string) $this->container['order_id']) < 1)) {
            throw new AssertionException("invalid value for 'order_id', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['shipment_id'] === null) {
            throw new AssertionException("'shipment_id' can't be null");
        }

        if ((\mb_strlen((string) $this->container['shipment_id']) < 1)) {
            throw new AssertionException("invalid value for 'shipment_id', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['shipment_status'] === null) {
            throw new AssertionException("'shipment_status' can't be null");
        }
    }

    /**
     * Gets created_at.
     */
    public function getCreatedAt() : ?\DateTimeInterface
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at.
     *
     * @param null|\DateTimeInterface $created_at timestamp when the shipment was created
     */
    public function setCreatedAt(?\DateTimeInterface $created_at) : self
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets external_reference_id.
     */
    public function getExternalReferenceId() : ?string
    {
        return $this->container['external_reference_id'];
    }

    /**
     * Sets external_reference_id.
     *
     * @param null|string $external_reference_id Optional client-provided reference ID that can be used to correlate this shipment with client resources. For example, to map this shipment to an internal bookkeeping order record.
     */
    public function setExternalReferenceId(?string $external_reference_id) : self
    {
        $this->container['external_reference_id'] = $external_reference_id;

        return $this;
    }

    /**
     * Gets order_id.
     */
    public function getOrderId() : string
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id.
     *
     * @param string $order_id the AWD inbound order ID that this inbound shipment belongs to
     */
    public function setOrderId(string $order_id) : self
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets shipment_id.
     */
    public function getShipmentId() : string
    {
        return $this->container['shipment_id'];
    }

    /**
     * Sets shipment_id.
     *
     * @param string $shipment_id a unique shipment ID
     */
    public function setShipmentId(string $shipment_id) : self
    {
        $this->container['shipment_id'] = $shipment_id;

        return $this;
    }

    /**
     * Gets shipment_status.
     */
    public function getShipmentStatus() : InboundShipmentStatus
    {
        return $this->container['shipment_status'];
    }

    /**
     * Sets shipment_status.
     *
     * @param InboundShipmentStatus $shipment_status shipment_status
     */
    public function setShipmentStatus(InboundShipmentStatus $shipment_status) : self
    {
        $this->container['shipment_status'] = $shipment_status;

        return $this;
    }

    /**
     * Gets updated_at.
     */
    public function getUpdatedAt() : ?\DateTimeInterface
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at.
     *
     * @param null|\DateTimeInterface $updated_at timestamp when the shipment was updated
     */
    public function setUpdatedAt(?\DateTimeInterface $updated_at) : self
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
