<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\VendorShipments;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Retail Procurement Shipments.
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TransportLabel implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'TransportLabel';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'label_create_date_time' => '\DateTimeInterface',
        'shipment_information' => '\AmazonPHP\SellingPartner\Model\VendorShipments\ShipmentInformation',
        'label_data' => '\AmazonPHP\SellingPartner\Model\VendorShipments\LabelData[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'label_create_date_time' => 'date-time',
        'shipment_information' => null,
        'label_data' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'label_create_date_time' => 'labelCreateDateTime',
        'shipment_information' => 'shipmentInformation',
        'label_data' => 'labelData',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'label_create_date_time' => 'setLabelCreateDateTime',
        'shipment_information' => 'setShipmentInformation',
        'label_data' => 'setLabelData',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'label_create_date_time' => 'getLabelCreateDateTime',
        'shipment_information' => 'getShipmentInformation',
        'label_data' => 'getLabelData',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label_create_date_time'] = $data['label_create_date_time'] ?? null;
        $this->container['shipment_information'] = $data['shipment_information'] ?? null;
        $this->container['label_data'] = $data['label_data'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['shipment_information'] !== null) {
            $this->container['shipment_information']->validate();
        }
    }

    /**
     * Gets label_create_date_time.
     */
    public function getLabelCreateDateTime() : ?\DateTimeInterface
    {
        return $this->container['label_create_date_time'];
    }

    /**
     * Sets label_create_date_time.
     *
     * @param null|\DateTimeInterface $label_create_date_time date on which label is created
     */
    public function setLabelCreateDateTime(?\DateTimeInterface $label_create_date_time) : self
    {
        $this->container['label_create_date_time'] = $label_create_date_time;

        return $this;
    }

    /**
     * Gets shipment_information.
     */
    public function getShipmentInformation() : ?ShipmentInformation
    {
        return $this->container['shipment_information'];
    }

    /**
     * Sets shipment_information.
     *
     * @param null|ShipmentInformation $shipment_information shipment_information
     */
    public function setShipmentInformation(?ShipmentInformation $shipment_information) : self
    {
        $this->container['shipment_information'] = $shipment_information;

        return $this;
    }

    /**
     * Gets label_data.
     *
     * @return null|LabelData[]
     */
    public function getLabelData() : ?array
    {
        return $this->container['label_data'];
    }

    /**
     * Sets label_data.
     *
     * @param null|LabelData[] $label_data indicates the label data,format and type associated
     */
    public function setLabelData(?array $label_data) : self
    {
        $this->container['label_data'] = $label_data;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
