<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\VendorShipments;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Retail Procurement Shipments.
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Shipment implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const TRANSACTION_TYPE__NEW = 'New';

    final public const TRANSACTION_TYPE_CANCEL = 'Cancel';

    final public const CURRENT_SHIPMENT_STATUS_CREATED = 'Created';

    final public const CURRENT_SHIPMENT_STATUS_TRANSPORTATION_REQUESTED = 'TransportationRequested';

    final public const CURRENT_SHIPMENT_STATUS_CARRIER_ASSIGNED = 'CarrierAssigned';

    final public const CURRENT_SHIPMENT_STATUS_SHIPPED = 'Shipped';

    final public const SHIPMENT_FREIGHT_TERM_COLLECT = 'Collect';

    final public const SHIPMENT_FREIGHT_TERM_PREPAID = 'Prepaid';

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Shipment';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'vendor_shipment_identifier' => 'string',
        'transaction_type' => 'string',
        'buyer_reference_number' => 'string',
        'transaction_date' => '\DateTimeInterface',
        'current_shipment_status' => 'string',
        'currentshipment_status_date' => '\DateTimeInterface',
        'shipment_status_details' => '\AmazonPHP\SellingPartner\Model\VendorShipments\ShipmentStatusDetails[]',
        'shipment_create_date' => '\DateTimeInterface',
        'shipment_confirm_date' => '\DateTimeInterface',
        'package_label_create_date' => '\DateTimeInterface',
        'shipment_freight_term' => 'string',
        'selling_party' => '\AmazonPHP\SellingPartner\Model\VendorShipments\PartyIdentification',
        'ship_from_party' => '\AmazonPHP\SellingPartner\Model\VendorShipments\PartyIdentification',
        'ship_to_party' => '\AmazonPHP\SellingPartner\Model\VendorShipments\PartyIdentification',
        'shipment_measurements' => '\AmazonPHP\SellingPartner\Model\VendorShipments\TransportShipmentMeasurements',
        'collect_freight_pickup_details' => '\AmazonPHP\SellingPartner\Model\VendorShipments\CollectFreightPickupDetails',
        'purchase_orders' => '\AmazonPHP\SellingPartner\Model\VendorShipments\PurchaseOrders[]',
        'import_details' => '\AmazonPHP\SellingPartner\Model\VendorShipments\ImportDetails',
        'containers' => '\AmazonPHP\SellingPartner\Model\VendorShipments\Containers[]',
        'transportation_details' => '\AmazonPHP\SellingPartner\Model\VendorShipments\TransportationDetails',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'vendor_shipment_identifier' => null,
        'transaction_type' => null,
        'buyer_reference_number' => null,
        'transaction_date' => 'date-time',
        'current_shipment_status' => null,
        'currentshipment_status_date' => 'date-time',
        'shipment_status_details' => null,
        'shipment_create_date' => 'date-time',
        'shipment_confirm_date' => 'date-time',
        'package_label_create_date' => 'date-time',
        'shipment_freight_term' => null,
        'selling_party' => null,
        'ship_from_party' => null,
        'ship_to_party' => null,
        'shipment_measurements' => null,
        'collect_freight_pickup_details' => null,
        'purchase_orders' => null,
        'import_details' => null,
        'containers' => null,
        'transportation_details' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'vendor_shipment_identifier' => 'vendorShipmentIdentifier',
        'transaction_type' => 'transactionType',
        'buyer_reference_number' => 'buyerReferenceNumber',
        'transaction_date' => 'transactionDate',
        'current_shipment_status' => 'currentShipmentStatus',
        'currentshipment_status_date' => 'currentshipmentStatusDate',
        'shipment_status_details' => 'shipmentStatusDetails',
        'shipment_create_date' => 'shipmentCreateDate',
        'shipment_confirm_date' => 'shipmentConfirmDate',
        'package_label_create_date' => 'packageLabelCreateDate',
        'shipment_freight_term' => 'shipmentFreightTerm',
        'selling_party' => 'sellingParty',
        'ship_from_party' => 'shipFromParty',
        'ship_to_party' => 'shipToParty',
        'shipment_measurements' => 'shipmentMeasurements',
        'collect_freight_pickup_details' => 'collectFreightPickupDetails',
        'purchase_orders' => 'purchaseOrders',
        'import_details' => 'importDetails',
        'containers' => 'containers',
        'transportation_details' => 'transportationDetails',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'vendor_shipment_identifier' => 'setVendorShipmentIdentifier',
        'transaction_type' => 'setTransactionType',
        'buyer_reference_number' => 'setBuyerReferenceNumber',
        'transaction_date' => 'setTransactionDate',
        'current_shipment_status' => 'setCurrentShipmentStatus',
        'currentshipment_status_date' => 'setCurrentshipmentStatusDate',
        'shipment_status_details' => 'setShipmentStatusDetails',
        'shipment_create_date' => 'setShipmentCreateDate',
        'shipment_confirm_date' => 'setShipmentConfirmDate',
        'package_label_create_date' => 'setPackageLabelCreateDate',
        'shipment_freight_term' => 'setShipmentFreightTerm',
        'selling_party' => 'setSellingParty',
        'ship_from_party' => 'setShipFromParty',
        'ship_to_party' => 'setShipToParty',
        'shipment_measurements' => 'setShipmentMeasurements',
        'collect_freight_pickup_details' => 'setCollectFreightPickupDetails',
        'purchase_orders' => 'setPurchaseOrders',
        'import_details' => 'setImportDetails',
        'containers' => 'setContainers',
        'transportation_details' => 'setTransportationDetails',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'vendor_shipment_identifier' => 'getVendorShipmentIdentifier',
        'transaction_type' => 'getTransactionType',
        'buyer_reference_number' => 'getBuyerReferenceNumber',
        'transaction_date' => 'getTransactionDate',
        'current_shipment_status' => 'getCurrentShipmentStatus',
        'currentshipment_status_date' => 'getCurrentshipmentStatusDate',
        'shipment_status_details' => 'getShipmentStatusDetails',
        'shipment_create_date' => 'getShipmentCreateDate',
        'shipment_confirm_date' => 'getShipmentConfirmDate',
        'package_label_create_date' => 'getPackageLabelCreateDate',
        'shipment_freight_term' => 'getShipmentFreightTerm',
        'selling_party' => 'getSellingParty',
        'ship_from_party' => 'getShipFromParty',
        'ship_to_party' => 'getShipToParty',
        'shipment_measurements' => 'getShipmentMeasurements',
        'collect_freight_pickup_details' => 'getCollectFreightPickupDetails',
        'purchase_orders' => 'getPurchaseOrders',
        'import_details' => 'getImportDetails',
        'containers' => 'getContainers',
        'transportation_details' => 'getTransportationDetails',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['vendor_shipment_identifier'] = $data['vendor_shipment_identifier'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['buyer_reference_number'] = $data['buyer_reference_number'] ?? null;
        $this->container['transaction_date'] = $data['transaction_date'] ?? null;
        $this->container['current_shipment_status'] = $data['current_shipment_status'] ?? null;
        $this->container['currentshipment_status_date'] = $data['currentshipment_status_date'] ?? null;
        $this->container['shipment_status_details'] = $data['shipment_status_details'] ?? null;
        $this->container['shipment_create_date'] = $data['shipment_create_date'] ?? null;
        $this->container['shipment_confirm_date'] = $data['shipment_confirm_date'] ?? null;
        $this->container['package_label_create_date'] = $data['package_label_create_date'] ?? null;
        $this->container['shipment_freight_term'] = $data['shipment_freight_term'] ?? null;
        $this->container['selling_party'] = $data['selling_party'] ?? null;
        $this->container['ship_from_party'] = $data['ship_from_party'] ?? null;
        $this->container['ship_to_party'] = $data['ship_to_party'] ?? null;
        $this->container['shipment_measurements'] = $data['shipment_measurements'] ?? null;
        $this->container['collect_freight_pickup_details'] = $data['collect_freight_pickup_details'] ?? null;
        $this->container['purchase_orders'] = $data['purchase_orders'] ?? null;
        $this->container['import_details'] = $data['import_details'] ?? null;
        $this->container['containers'] = $data['containers'] ?? null;
        $this->container['transportation_details'] = $data['transportation_details'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getTransactionTypeAllowableValues() : array
    {
        return [
            self::TRANSACTION_TYPE__NEW,
            self::TRANSACTION_TYPE_CANCEL,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getCurrentShipmentStatusAllowableValues() : array
    {
        return [
            self::CURRENT_SHIPMENT_STATUS_CREATED,
            self::CURRENT_SHIPMENT_STATUS_TRANSPORTATION_REQUESTED,
            self::CURRENT_SHIPMENT_STATUS_CARRIER_ASSIGNED,
            self::CURRENT_SHIPMENT_STATUS_SHIPPED,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getShipmentFreightTermAllowableValues() : array
    {
        return [
            self::SHIPMENT_FREIGHT_TERM_COLLECT,
            self::SHIPMENT_FREIGHT_TERM_PREPAID,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['vendor_shipment_identifier'] === null) {
            throw new AssertionException("'vendor_shipment_identifier' can't be null");
        }

        if ($this->container['transaction_type'] === null) {
            throw new AssertionException("'transaction_type' can't be null");
        }

        $allowedValues = $this->getTransactionTypeAllowableValues();

        if (null !== $this->container['transaction_type'] && !\in_array($this->container['transaction_type'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'transaction_type', must be one of '%s'",
                    $this->container['transaction_type'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['transaction_date'] === null) {
            throw new AssertionException("'transaction_date' can't be null");
        }

        $allowedValues = $this->getCurrentShipmentStatusAllowableValues();

        if (null !== $this->container['current_shipment_status'] && !\in_array($this->container['current_shipment_status'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'current_shipment_status', must be one of '%s'",
                    $this->container['current_shipment_status'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        $allowedValues = $this->getShipmentFreightTermAllowableValues();

        if (null !== $this->container['shipment_freight_term'] && !\in_array($this->container['shipment_freight_term'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'shipment_freight_term', must be one of '%s'",
                    $this->container['shipment_freight_term'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['selling_party'] === null) {
            throw new AssertionException("'selling_party' can't be null");
        }

        $this->container['selling_party']->validate();

        if ($this->container['ship_from_party'] === null) {
            throw new AssertionException("'ship_from_party' can't be null");
        }

        $this->container['ship_from_party']->validate();

        if ($this->container['ship_to_party'] === null) {
            throw new AssertionException("'ship_to_party' can't be null");
        }

        $this->container['ship_to_party']->validate();

        if ($this->container['shipment_measurements'] !== null) {
            $this->container['shipment_measurements']->validate();
        }

        if ($this->container['collect_freight_pickup_details'] !== null) {
            $this->container['collect_freight_pickup_details']->validate();
        }

        if ($this->container['import_details'] !== null) {
            $this->container['import_details']->validate();
        }

        if ($this->container['transportation_details'] !== null) {
            $this->container['transportation_details']->validate();
        }
    }

    /**
     * Gets vendor_shipment_identifier.
     */
    public function getVendorShipmentIdentifier() : string
    {
        return $this->container['vendor_shipment_identifier'];
    }

    /**
     * Sets vendor_shipment_identifier.
     *
     * @param string $vendor_shipment_identifier unique Transportation ID created by Vendor (Should not be used over the last 365 days)
     */
    public function setVendorShipmentIdentifier(string $vendor_shipment_identifier) : self
    {
        $this->container['vendor_shipment_identifier'] = $vendor_shipment_identifier;

        return $this;
    }

    /**
     * Gets transaction_type.
     */
    public function getTransactionType() : string
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type.
     *
     * @param string $transaction_type Indicates the type of  transportation request such as (New,Cancel,Confirm and PackageLabelRequest). Each transactiontype has a unique set of operation and there are corresponding details to be populated for each operation.
     */
    public function setTransactionType(string $transaction_type) : self
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets buyer_reference_number.
     */
    public function getBuyerReferenceNumber() : ?string
    {
        return $this->container['buyer_reference_number'];
    }

    /**
     * Sets buyer_reference_number.
     *
     * @param null|string $buyer_reference_number The buyer Reference Number is a unique identifier generated by buyer for all Collect/WePay shipments when you submit a transportation request. This field is mandatory for Collect/WePay shipments.
     */
    public function setBuyerReferenceNumber(?string $buyer_reference_number) : self
    {
        $this->container['buyer_reference_number'] = $buyer_reference_number;

        return $this;
    }

    /**
     * Gets transaction_date.
     */
    public function getTransactionDate() : \DateTimeInterface
    {
        return $this->container['transaction_date'];
    }

    /**
     * Sets transaction_date.
     *
     * @param \DateTimeInterface $transaction_date date on which the transportation request was submitted
     */
    public function setTransactionDate(\DateTimeInterface $transaction_date) : self
    {
        $this->container['transaction_date'] = $transaction_date;

        return $this;
    }

    /**
     * Gets current_shipment_status.
     */
    public function getCurrentShipmentStatus() : ?string
    {
        return $this->container['current_shipment_status'];
    }

    /**
     * Sets current_shipment_status.
     *
     * @param null|string $current_shipment_status indicates the current shipment status
     */
    public function setCurrentShipmentStatus(?string $current_shipment_status) : self
    {
        $this->container['current_shipment_status'] = $current_shipment_status;

        return $this;
    }

    /**
     * Gets currentshipment_status_date.
     */
    public function getCurrentshipmentStatusDate() : ?\DateTimeInterface
    {
        return $this->container['currentshipment_status_date'];
    }

    /**
     * Sets currentshipment_status_date.
     *
     * @param null|\DateTimeInterface $currentshipment_status_date date and time when the last status was updated
     */
    public function setCurrentshipmentStatusDate(?\DateTimeInterface $currentshipment_status_date) : self
    {
        $this->container['currentshipment_status_date'] = $currentshipment_status_date;

        return $this;
    }

    /**
     * Gets shipment_status_details.
     *
     * @return null|ShipmentStatusDetails[]
     */
    public function getShipmentStatusDetails() : ?array
    {
        return $this->container['shipment_status_details'];
    }

    /**
     * Sets shipment_status_details.
     *
     * @param null|ShipmentStatusDetails[] $shipment_status_details indicates the list of current shipment status details and when the last update was received from carrier this is available on shipment Details response
     */
    public function setShipmentStatusDetails(?array $shipment_status_details) : self
    {
        $this->container['shipment_status_details'] = $shipment_status_details;

        return $this;
    }

    /**
     * Gets shipment_create_date.
     */
    public function getShipmentCreateDate() : ?\DateTimeInterface
    {
        return $this->container['shipment_create_date'];
    }

    /**
     * Sets shipment_create_date.
     *
     * @param null|\DateTimeInterface $shipment_create_date the date and time of the shipment request created by vendor
     */
    public function setShipmentCreateDate(?\DateTimeInterface $shipment_create_date) : self
    {
        $this->container['shipment_create_date'] = $shipment_create_date;

        return $this;
    }

    /**
     * Gets shipment_confirm_date.
     */
    public function getShipmentConfirmDate() : ?\DateTimeInterface
    {
        return $this->container['shipment_confirm_date'];
    }

    /**
     * Sets shipment_confirm_date.
     *
     * @param null|\DateTimeInterface $shipment_confirm_date The date and time of the departure of the shipment from the vendor's location. Vendors are requested to send ASNs within 30 minutes of departure from their warehouse/distribution center or at least 6 hours prior to the appointment time at the Buyer destination warehouse, whichever is sooner. Shipped date mentioned in the shipment confirmation should not be in the future.
     */
    public function setShipmentConfirmDate(?\DateTimeInterface $shipment_confirm_date) : self
    {
        $this->container['shipment_confirm_date'] = $shipment_confirm_date;

        return $this;
    }

    /**
     * Gets package_label_create_date.
     */
    public function getPackageLabelCreateDate() : ?\DateTimeInterface
    {
        return $this->container['package_label_create_date'];
    }

    /**
     * Sets package_label_create_date.
     *
     * @param null|\DateTimeInterface $package_label_create_date the date and time of the package label created for the shipment by buyer
     */
    public function setPackageLabelCreateDate(?\DateTimeInterface $package_label_create_date) : self
    {
        $this->container['package_label_create_date'] = $package_label_create_date;

        return $this;
    }

    /**
     * Gets shipment_freight_term.
     */
    public function getShipmentFreightTerm() : ?string
    {
        return $this->container['shipment_freight_term'];
    }

    /**
     * Sets shipment_freight_term.
     *
     * @param null|string $shipment_freight_term Indicates if this transportation request is WePay/Collect or TheyPay/Prepaid. This is a mandatory information.
     */
    public function setShipmentFreightTerm(?string $shipment_freight_term) : self
    {
        $this->container['shipment_freight_term'] = $shipment_freight_term;

        return $this;
    }

    /**
     * Gets selling_party.
     */
    public function getSellingParty() : PartyIdentification
    {
        return $this->container['selling_party'];
    }

    /**
     * Sets selling_party.
     *
     * @param PartyIdentification $selling_party selling_party
     */
    public function setSellingParty(PartyIdentification $selling_party) : self
    {
        $this->container['selling_party'] = $selling_party;

        return $this;
    }

    /**
     * Gets ship_from_party.
     */
    public function getShipFromParty() : PartyIdentification
    {
        return $this->container['ship_from_party'];
    }

    /**
     * Sets ship_from_party.
     *
     * @param PartyIdentification $ship_from_party ship_from_party
     */
    public function setShipFromParty(PartyIdentification $ship_from_party) : self
    {
        $this->container['ship_from_party'] = $ship_from_party;

        return $this;
    }

    /**
     * Gets ship_to_party.
     */
    public function getShipToParty() : PartyIdentification
    {
        return $this->container['ship_to_party'];
    }

    /**
     * Sets ship_to_party.
     *
     * @param PartyIdentification $ship_to_party ship_to_party
     */
    public function setShipToParty(PartyIdentification $ship_to_party) : self
    {
        $this->container['ship_to_party'] = $ship_to_party;

        return $this;
    }

    /**
     * Gets shipment_measurements.
     */
    public function getShipmentMeasurements() : ?TransportShipmentMeasurements
    {
        return $this->container['shipment_measurements'];
    }

    /**
     * Sets shipment_measurements.
     *
     * @param null|TransportShipmentMeasurements $shipment_measurements shipment_measurements
     */
    public function setShipmentMeasurements(?TransportShipmentMeasurements $shipment_measurements) : self
    {
        $this->container['shipment_measurements'] = $shipment_measurements;

        return $this;
    }

    /**
     * Gets collect_freight_pickup_details.
     */
    public function getCollectFreightPickupDetails() : ?CollectFreightPickupDetails
    {
        return $this->container['collect_freight_pickup_details'];
    }

    /**
     * Sets collect_freight_pickup_details.
     *
     * @param null|CollectFreightPickupDetails $collect_freight_pickup_details collect_freight_pickup_details
     */
    public function setCollectFreightPickupDetails(?CollectFreightPickupDetails $collect_freight_pickup_details) : self
    {
        $this->container['collect_freight_pickup_details'] = $collect_freight_pickup_details;

        return $this;
    }

    /**
     * Gets purchase_orders.
     *
     * @return null|PurchaseOrders[]
     */
    public function getPurchaseOrders() : ?array
    {
        return $this->container['purchase_orders'];
    }

    /**
     * Sets purchase_orders.
     *
     * @param null|PurchaseOrders[] $purchase_orders Indicates the purchase orders involved for the transportation request. This group is an array create 1 for each PO and list their corresponding items. This information is used for deciding the route,truck allocation and storage efficiently. This is a mandatory information for Buyer performing transportation from vendor warehouse (WePay/Collect)
     */
    public function setPurchaseOrders(?array $purchase_orders) : self
    {
        $this->container['purchase_orders'] = $purchase_orders;

        return $this;
    }

    /**
     * Gets import_details.
     */
    public function getImportDetails() : ?ImportDetails
    {
        return $this->container['import_details'];
    }

    /**
     * Sets import_details.
     *
     * @param null|ImportDetails $import_details import_details
     */
    public function setImportDetails(?ImportDetails $import_details) : self
    {
        $this->container['import_details'] = $import_details;

        return $this;
    }

    /**
     * Gets containers.
     *
     * @return null|Containers[]
     */
    public function getContainers() : ?array
    {
        return $this->container['containers'];
    }

    /**
     * Sets containers.
     *
     * @param null|Containers[] $containers A list of the items in this transportation and their associated inner container details. If any of the item detail fields are common at a carton or a pallet level, provide them at the corresponding carton or pallet level.
     */
    public function setContainers(?array $containers) : self
    {
        $this->container['containers'] = $containers;

        return $this;
    }

    /**
     * Gets transportation_details.
     */
    public function getTransportationDetails() : ?TransportationDetails
    {
        return $this->container['transportation_details'];
    }

    /**
     * Sets transportation_details.
     *
     * @param null|TransportationDetails $transportation_details transportation_details
     */
    public function setTransportationDetails(?TransportationDetails $transportation_details) : self
    {
        $this->container['transportation_details'] = $transportation_details;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
