<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\VendorShipments;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Retail Procurement Shipments.
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class LabelData implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const LABEL_FORMAT_PDF = 'PDF';

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'LabelData';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'label_sequence_number' => 'int',
        'label_format' => 'string',
        'carrier_code' => 'string',
        'tracking_id' => 'string',
        'label' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'label_sequence_number' => null,
        'label_format' => null,
        'carrier_code' => null,
        'tracking_id' => null,
        'label' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'label_sequence_number' => 'labelSequenceNumber',
        'label_format' => 'labelFormat',
        'carrier_code' => 'carrierCode',
        'tracking_id' => 'trackingId',
        'label' => 'label',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'label_sequence_number' => 'setLabelSequenceNumber',
        'label_format' => 'setLabelFormat',
        'carrier_code' => 'setCarrierCode',
        'tracking_id' => 'setTrackingId',
        'label' => 'setLabel',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'label_sequence_number' => 'getLabelSequenceNumber',
        'label_format' => 'getLabelFormat',
        'carrier_code' => 'getCarrierCode',
        'tracking_id' => 'getTrackingId',
        'label' => 'getLabel',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label_sequence_number'] = $data['label_sequence_number'] ?? null;
        $this->container['label_format'] = $data['label_format'] ?? null;
        $this->container['carrier_code'] = $data['carrier_code'] ?? null;
        $this->container['tracking_id'] = $data['tracking_id'] ?? null;
        $this->container['label'] = $data['label'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getLabelFormatAllowableValues() : array
    {
        return [
            self::LABEL_FORMAT_PDF,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        $allowedValues = $this->getLabelFormatAllowableValues();

        if (null !== $this->container['label_format'] && !\in_array($this->container['label_format'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'label_format', must be one of '%s'",
                    $this->container['label_format'],
                    \implode("', '", $allowedValues)
                )
            );
        }
    }

    /**
     * Gets label_sequence_number.
     */
    public function getLabelSequenceNumber() : ?int
    {
        return $this->container['label_sequence_number'];
    }

    /**
     * Sets label_sequence_number.
     *
     * @param null|int $label_sequence_number a sequential number assigned to each label within a shipment
     */
    public function setLabelSequenceNumber(?int $label_sequence_number) : self
    {
        $this->container['label_sequence_number'] = $label_sequence_number;

        return $this;
    }

    /**
     * Gets label_format.
     */
    public function getLabelFormat() : ?string
    {
        return $this->container['label_format'];
    }

    /**
     * Sets label_format.
     *
     * @param null|string $label_format the format of the label
     */
    public function setLabelFormat(?string $label_format) : self
    {
        $this->container['label_format'] = $label_format;

        return $this;
    }

    /**
     * Gets carrier_code.
     */
    public function getCarrierCode() : ?string
    {
        return $this->container['carrier_code'];
    }

    /**
     * Sets carrier_code.
     *
     * @param null|string $carrier_code unique identification of the carrier
     */
    public function setCarrierCode(?string $carrier_code) : self
    {
        $this->container['carrier_code'] = $carrier_code;

        return $this;
    }

    /**
     * Gets tracking_id.
     */
    public function getTrackingId() : ?string
    {
        return $this->container['tracking_id'];
    }

    /**
     * Sets tracking_id.
     *
     * @param null|string $tracking_id tracking Id for the transportation
     */
    public function setTrackingId(?string $tracking_id) : self
    {
        $this->container['tracking_id'] = $tracking_id;

        return $this;
    }

    /**
     * Gets label.
     */
    public function getLabel() : ?string
    {
        return $this->container['label'];
    }

    /**
     * Sets label.
     *
     * @param null|string $label the base-64 encoded string that represents the shipment label
     */
    public function setLabel(?string $label) : self
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
