<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Sellers;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for Sellers.
 *
 * The Selling Partner API for Sellers lets you retrieve information on behalf of sellers about their seller account, such as the marketplaces they participate in. Along with listing the marketplaces that a seller can sell in, the API also provides additional information about the marketplace such as the default language and the default currency. The API also provides seller-specific information such as whether the seller has suspended listings in that marketplace.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Account implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const BUSINESS_TYPE_CHARITY = 'CHARITY';

    final public const BUSINESS_TYPE_CRAFTSMAN = 'CRAFTSMAN';

    final public const BUSINESS_TYPE_NATURAL_PERSON_COMPANY = 'NATURAL_PERSON_COMPANY';

    final public const BUSINESS_TYPE_PUBLIC_LISTED = 'PUBLIC_LISTED';

    final public const BUSINESS_TYPE_PRIVATE_LIMITED = 'PRIVATE_LIMITED';

    final public const BUSINESS_TYPE_SOLE_PROPRIETORSHIP = 'SOLE_PROPRIETORSHIP';

    final public const BUSINESS_TYPE_STATE_OWNED = 'STATE_OWNED';

    final public const BUSINESS_TYPE_INDIVIDUAL = 'INDIVIDUAL';

    final public const SELLING_PLAN_PROFESSIONAL = 'PROFESSIONAL';

    final public const SELLING_PLAN_INDIVIDUAL = 'INDIVIDUAL';

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Account';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'marketplace_participation_list' => '\AmazonPHP\SellingPartner\Model\Sellers\MarketplaceParticipation[]',
        'business_type' => 'string',
        'selling_plan' => 'string',
        'business' => '\AmazonPHP\SellingPartner\Model\Sellers\Business',
        'primary_contact' => '\AmazonPHP\SellingPartner\Model\Sellers\PrimaryContact',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'marketplace_participation_list' => null,
        'business_type' => null,
        'selling_plan' => null,
        'business' => null,
        'primary_contact' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'marketplace_participation_list' => 'marketplaceParticipationList',
        'business_type' => 'businessType',
        'selling_plan' => 'sellingPlan',
        'business' => 'business',
        'primary_contact' => 'primaryContact',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'marketplace_participation_list' => 'setMarketplaceParticipationList',
        'business_type' => 'setBusinessType',
        'selling_plan' => 'setSellingPlan',
        'business' => 'setBusiness',
        'primary_contact' => 'setPrimaryContact',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'marketplace_participation_list' => 'getMarketplaceParticipationList',
        'business_type' => 'getBusinessType',
        'selling_plan' => 'getSellingPlan',
        'business' => 'getBusiness',
        'primary_contact' => 'getPrimaryContact',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_participation_list'] = $data['marketplace_participation_list'] ?? null;
        $this->container['business_type'] = $data['business_type'] ?? null;
        $this->container['selling_plan'] = $data['selling_plan'] ?? null;
        $this->container['business'] = $data['business'] ?? null;
        $this->container['primary_contact'] = $data['primary_contact'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getBusinessTypeAllowableValues() : array
    {
        return [
            self::BUSINESS_TYPE_CHARITY,
            self::BUSINESS_TYPE_CRAFTSMAN,
            self::BUSINESS_TYPE_NATURAL_PERSON_COMPANY,
            self::BUSINESS_TYPE_PUBLIC_LISTED,
            self::BUSINESS_TYPE_PRIVATE_LIMITED,
            self::BUSINESS_TYPE_SOLE_PROPRIETORSHIP,
            self::BUSINESS_TYPE_STATE_OWNED,
            self::BUSINESS_TYPE_INDIVIDUAL,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getSellingPlanAllowableValues() : array
    {
        return [
            self::SELLING_PLAN_PROFESSIONAL,
            self::SELLING_PLAN_INDIVIDUAL,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['marketplace_participation_list'] === null) {
            throw new AssertionException("'marketplace_participation_list' can't be null");
        }

        if ($this->container['business_type'] === null) {
            throw new AssertionException("'business_type' can't be null");
        }

        $allowedValues = $this->getBusinessTypeAllowableValues();

        if (null !== $this->container['business_type'] && !\in_array($this->container['business_type'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'business_type', must be one of '%s'",
                    $this->container['business_type'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['selling_plan'] === null) {
            throw new AssertionException("'selling_plan' can't be null");
        }

        $allowedValues = $this->getSellingPlanAllowableValues();

        if (null !== $this->container['selling_plan'] && !\in_array($this->container['selling_plan'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'selling_plan', must be one of '%s'",
                    $this->container['selling_plan'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['business'] !== null) {
            $this->container['business']->validate();
        }

        if ($this->container['primary_contact'] !== null) {
            $this->container['primary_contact']->validate();
        }
    }

    /**
     * Gets marketplace_participation_list.
     *
     * @return MarketplaceParticipation[]
     */
    public function getMarketplaceParticipationList() : array
    {
        return $this->container['marketplace_participation_list'];
    }

    /**
     * Sets marketplace_participation_list.
     *
     * @param MarketplaceParticipation[] $marketplace_participation_list list of marketplace participations
     */
    public function setMarketplaceParticipationList(array $marketplace_participation_list) : self
    {
        $this->container['marketplace_participation_list'] = $marketplace_participation_list;

        return $this;
    }

    /**
     * Gets business_type.
     */
    public function getBusinessType() : string
    {
        return $this->container['business_type'];
    }

    /**
     * Sets business_type.
     *
     * @param string $business_type the type of business registered for the seller account
     */
    public function setBusinessType(string $business_type) : self
    {
        $this->container['business_type'] = $business_type;

        return $this;
    }

    /**
     * Gets selling_plan.
     */
    public function getSellingPlan() : string
    {
        return $this->container['selling_plan'];
    }

    /**
     * Sets selling_plan.
     *
     * @param string $selling_plan the selling plan details
     */
    public function setSellingPlan(string $selling_plan) : self
    {
        $this->container['selling_plan'] = $selling_plan;

        return $this;
    }

    /**
     * Gets business.
     */
    public function getBusiness() : ?Business
    {
        return $this->container['business'];
    }

    /**
     * Sets business.
     *
     * @param null|Business $business business
     */
    public function setBusiness(?Business $business) : self
    {
        $this->container['business'] = $business;

        return $this;
    }

    /**
     * Gets primary_contact.
     */
    public function getPrimaryContact() : ?PrimaryContact
    {
        return $this->container['primary_contact'];
    }

    /**
     * Sets primary_contact.
     *
     * @param null|PrimaryContact $primary_contact primary_contact
     */
    public function setPrimaryContact(?PrimaryContact $primary_contact) : self
    {
        $this->container['primary_contact'] = $primary_contact;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
