<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Orders;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Orders v0.
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ShippingConstraints implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'ShippingConstraints';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'pallet_delivery' => '\AmazonPHP\SellingPartner\Model\Orders\ConstraintType',
        'signature_confirmation' => '\AmazonPHP\SellingPartner\Model\Orders\ConstraintType',
        'recipient_identity_verification' => '\AmazonPHP\SellingPartner\Model\Orders\ConstraintType',
        'recipient_age_verification' => '\AmazonPHP\SellingPartner\Model\Orders\ConstraintType',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'pallet_delivery' => null,
        'signature_confirmation' => null,
        'recipient_identity_verification' => null,
        'recipient_age_verification' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'pallet_delivery' => 'PalletDelivery',
        'signature_confirmation' => 'SignatureConfirmation',
        'recipient_identity_verification' => 'RecipientIdentityVerification',
        'recipient_age_verification' => 'RecipientAgeVerification',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'pallet_delivery' => 'setPalletDelivery',
        'signature_confirmation' => 'setSignatureConfirmation',
        'recipient_identity_verification' => 'setRecipientIdentityVerification',
        'recipient_age_verification' => 'setRecipientAgeVerification',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'pallet_delivery' => 'getPalletDelivery',
        'signature_confirmation' => 'getSignatureConfirmation',
        'recipient_identity_verification' => 'getRecipientIdentityVerification',
        'recipient_age_verification' => 'getRecipientAgeVerification',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['pallet_delivery'] = $data['pallet_delivery'] ?? null;
        $this->container['signature_confirmation'] = $data['signature_confirmation'] ?? null;
        $this->container['recipient_identity_verification'] = $data['recipient_identity_verification'] ?? null;
        $this->container['recipient_age_verification'] = $data['recipient_age_verification'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
    }

    /**
     * Gets pallet_delivery.
     */
    public function getPalletDelivery() : ?ConstraintType
    {
        return $this->container['pallet_delivery'];
    }

    /**
     * Sets pallet_delivery.
     *
     * @param null|ConstraintType $pallet_delivery pallet_delivery
     */
    public function setPalletDelivery(?ConstraintType $pallet_delivery) : self
    {
        $this->container['pallet_delivery'] = $pallet_delivery;

        return $this;
    }

    /**
     * Gets signature_confirmation.
     */
    public function getSignatureConfirmation() : ?ConstraintType
    {
        return $this->container['signature_confirmation'];
    }

    /**
     * Sets signature_confirmation.
     *
     * @param null|ConstraintType $signature_confirmation signature_confirmation
     */
    public function setSignatureConfirmation(?ConstraintType $signature_confirmation) : self
    {
        $this->container['signature_confirmation'] = $signature_confirmation;

        return $this;
    }

    /**
     * Gets recipient_identity_verification.
     */
    public function getRecipientIdentityVerification() : ?ConstraintType
    {
        return $this->container['recipient_identity_verification'];
    }

    /**
     * Sets recipient_identity_verification.
     *
     * @param null|ConstraintType $recipient_identity_verification recipient_identity_verification
     */
    public function setRecipientIdentityVerification(?ConstraintType $recipient_identity_verification) : self
    {
        $this->container['recipient_identity_verification'] = $recipient_identity_verification;

        return $this;
    }

    /**
     * Gets recipient_age_verification.
     */
    public function getRecipientAgeVerification() : ?ConstraintType
    {
        return $this->container['recipient_age_verification'];
    }

    /**
     * Sets recipient_age_verification.
     *
     * @param null|ConstraintType $recipient_age_verification recipient_age_verification
     */
    public function setRecipientAgeVerification(?ConstraintType $recipient_age_verification) : self
    {
        $this->container['recipient_age_verification'] = $recipient_age_verification;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
