<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Orders;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Orders v0.
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PrescriptionDetail implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'PrescriptionDetail';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'prescription_id' => 'string',
        'expiration_date' => '\DateTimeInterface',
        'written_quantity' => 'int',
        'total_refills_authorized' => 'int',
        'refills_remaining' => 'int',
        'clinic_id' => 'string',
        'usage_instructions' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'prescription_id' => null,
        'expiration_date' => 'date-time',
        'written_quantity' => null,
        'total_refills_authorized' => null,
        'refills_remaining' => null,
        'clinic_id' => null,
        'usage_instructions' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'prescription_id' => 'prescriptionId',
        'expiration_date' => 'expirationDate',
        'written_quantity' => 'writtenQuantity',
        'total_refills_authorized' => 'totalRefillsAuthorized',
        'refills_remaining' => 'refillsRemaining',
        'clinic_id' => 'clinicId',
        'usage_instructions' => 'usageInstructions',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'prescription_id' => 'setPrescriptionId',
        'expiration_date' => 'setExpirationDate',
        'written_quantity' => 'setWrittenQuantity',
        'total_refills_authorized' => 'setTotalRefillsAuthorized',
        'refills_remaining' => 'setRefillsRemaining',
        'clinic_id' => 'setClinicId',
        'usage_instructions' => 'setUsageInstructions',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'prescription_id' => 'getPrescriptionId',
        'expiration_date' => 'getExpirationDate',
        'written_quantity' => 'getWrittenQuantity',
        'total_refills_authorized' => 'getTotalRefillsAuthorized',
        'refills_remaining' => 'getRefillsRemaining',
        'clinic_id' => 'getClinicId',
        'usage_instructions' => 'getUsageInstructions',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['prescription_id'] = $data['prescription_id'] ?? null;
        $this->container['expiration_date'] = $data['expiration_date'] ?? null;
        $this->container['written_quantity'] = $data['written_quantity'] ?? null;
        $this->container['total_refills_authorized'] = $data['total_refills_authorized'] ?? null;
        $this->container['refills_remaining'] = $data['refills_remaining'] ?? null;
        $this->container['clinic_id'] = $data['clinic_id'] ?? null;
        $this->container['usage_instructions'] = $data['usage_instructions'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['prescription_id'] === null) {
            throw new AssertionException("'prescription_id' can't be null");
        }

        if ($this->container['expiration_date'] === null) {
            throw new AssertionException("'expiration_date' can't be null");
        }

        if ($this->container['written_quantity'] === null) {
            throw new AssertionException("'written_quantity' can't be null");
        }

        if (($this->container['written_quantity'] < 1)) {
            throw new AssertionException("invalid value for 'written_quantity', must be bigger than or equal to 1.");
        }

        if ($this->container['total_refills_authorized'] === null) {
            throw new AssertionException("'total_refills_authorized' can't be null");
        }

        if (($this->container['total_refills_authorized'] < 0)) {
            throw new AssertionException("invalid value for 'total_refills_authorized', must be bigger than or equal to 0.");
        }

        if ($this->container['refills_remaining'] === null) {
            throw new AssertionException("'refills_remaining' can't be null");
        }

        if (($this->container['refills_remaining'] < 0)) {
            throw new AssertionException("invalid value for 'refills_remaining', must be bigger than or equal to 0.");
        }

        if ($this->container['clinic_id'] === null) {
            throw new AssertionException("'clinic_id' can't be null");
        }

        if ($this->container['usage_instructions'] === null) {
            throw new AssertionException("'usage_instructions' can't be null");
        }
    }

    /**
     * Gets prescription_id.
     */
    public function getPrescriptionId() : string
    {
        return $this->container['prescription_id'];
    }

    /**
     * Sets prescription_id.
     *
     * @param string $prescription_id the identifier for the prescription used to verify the regulated product
     */
    public function setPrescriptionId(string $prescription_id) : self
    {
        $this->container['prescription_id'] = $prescription_id;

        return $this;
    }

    /**
     * Gets expiration_date.
     */
    public function getExpirationDate() : \DateTimeInterface
    {
        return $this->container['expiration_date'];
    }

    /**
     * Sets expiration_date.
     *
     * @param \DateTimeInterface $expiration_date The expiration date of the prescription used to verify the regulated product, in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format.
     */
    public function setExpirationDate(\DateTimeInterface $expiration_date) : self
    {
        $this->container['expiration_date'] = $expiration_date;

        return $this;
    }

    /**
     * Gets written_quantity.
     */
    public function getWrittenQuantity() : int
    {
        return $this->container['written_quantity'];
    }

    /**
     * Sets written_quantity.
     *
     * @param int $written_quantity the number of units in each fill as provided in the prescription
     */
    public function setWrittenQuantity(int $written_quantity) : self
    {
        $this->container['written_quantity'] = $written_quantity;

        return $this;
    }

    /**
     * Gets total_refills_authorized.
     */
    public function getTotalRefillsAuthorized() : int
    {
        return $this->container['total_refills_authorized'];
    }

    /**
     * Sets total_refills_authorized.
     *
     * @param int $total_refills_authorized The total number of refills written in the original prescription used to verify the regulated product. If a prescription originally had no refills, this value must be 0.
     */
    public function setTotalRefillsAuthorized(int $total_refills_authorized) : self
    {
        $this->container['total_refills_authorized'] = $total_refills_authorized;

        return $this;
    }

    /**
     * Gets refills_remaining.
     */
    public function getRefillsRemaining() : int
    {
        return $this->container['refills_remaining'];
    }

    /**
     * Sets refills_remaining.
     *
     * @param int $refills_remaining The number of refills remaining for the prescription used to verify the regulated product. If a prescription originally had 10 total refills, this value must be `10` for the first order, `9` for the second order, and `0` for the eleventh order. If a prescription originally had no refills, this value must be 0.
     */
    public function setRefillsRemaining(int $refills_remaining) : self
    {
        $this->container['refills_remaining'] = $refills_remaining;

        return $this;
    }

    /**
     * Gets clinic_id.
     */
    public function getClinicId() : string
    {
        return $this->container['clinic_id'];
    }

    /**
     * Sets clinic_id.
     *
     * @param string $clinic_id the identifier for the clinic which provided the prescription used to verify the regulated product
     */
    public function setClinicId(string $clinic_id) : self
    {
        $this->container['clinic_id'] = $clinic_id;

        return $this;
    }

    /**
     * Gets usage_instructions.
     */
    public function getUsageInstructions() : string
    {
        return $this->container['usage_instructions'];
    }

    /**
     * Sets usage_instructions.
     *
     * @param string $usage_instructions the instructions for the prescription as provided by the approver of the regulated product
     */
    public function setUsageInstructions(string $usage_instructions) : self
    {
        $this->container['usage_instructions'] = $usage_instructions;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
