<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Orders;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Orders v0.
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Order implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    final public const ORDER_STATUS_PENDING = 'Pending';

    final public const ORDER_STATUS_UNSHIPPED = 'Unshipped';

    final public const ORDER_STATUS_PARTIALLY_SHIPPED = 'PartiallyShipped';

    final public const ORDER_STATUS_SHIPPED = 'Shipped';

    final public const ORDER_STATUS_CANCELED = 'Canceled';

    final public const ORDER_STATUS_UNFULFILLABLE = 'Unfulfillable';

    final public const ORDER_STATUS_INVOICE_UNCONFIRMED = 'InvoiceUnconfirmed';

    final public const ORDER_STATUS_PENDING_AVAILABILITY = 'PendingAvailability';

    final public const FULFILLMENT_CHANNEL_MFN = 'MFN';

    final public const FULFILLMENT_CHANNEL_AFN = 'AFN';

    final public const PAYMENT_METHOD_COD = 'COD';

    final public const PAYMENT_METHOD_CVS = 'CVS';

    final public const PAYMENT_METHOD_OTHER = 'Other';

    final public const ORDER_TYPE_STANDARD_ORDER = 'StandardOrder';

    final public const ORDER_TYPE_LONG_LEAD_TIME_ORDER = 'LongLeadTimeOrder';

    final public const ORDER_TYPE_PREORDER = 'Preorder';

    final public const ORDER_TYPE_BACK_ORDER = 'BackOrder';

    final public const ORDER_TYPE_SOURCING_ON_DEMAND_ORDER = 'SourcingOnDemandOrder';

    final public const BUYER_INVOICE_PREFERENCE_INDIVIDUAL = 'INDIVIDUAL';

    final public const BUYER_INVOICE_PREFERENCE_BUSINESS = 'BUSINESS';

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Order';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'amazon_order_id' => 'string',
        'seller_order_id' => 'string',
        'purchase_date' => 'string',
        'last_update_date' => 'string',
        'order_status' => 'string',
        'fulfillment_channel' => 'string',
        'sales_channel' => 'string',
        'order_channel' => 'string',
        'ship_service_level' => 'string',
        'order_total' => '\AmazonPHP\SellingPartner\Model\Orders\Money',
        'number_of_items_shipped' => 'int',
        'number_of_items_unshipped' => 'int',
        'payment_execution_detail' => '\AmazonPHP\SellingPartner\Model\Orders\PaymentExecutionDetailItem[]',
        'payment_method' => 'string',
        'payment_method_details' => 'string[]',
        'marketplace_id' => 'string',
        'shipment_service_level_category' => 'string',
        'easy_ship_shipment_status' => '\AmazonPHP\SellingPartner\Model\Orders\EasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'string',
        'order_type' => 'string',
        'earliest_ship_date' => 'string',
        'latest_ship_date' => 'string',
        'earliest_delivery_date' => 'string',
        'latest_delivery_date' => 'string',
        'is_business_order' => 'bool',
        'is_prime' => 'bool',
        'is_premium_order' => 'bool',
        'is_global_express_enabled' => 'bool',
        'replaced_order_id' => 'string',
        'is_replacement_order' => 'bool',
        'promise_response_due_date' => 'string',
        'is_estimated_ship_date_set' => 'bool',
        'is_sold_by_ab' => 'bool',
        'is_iba' => 'bool',
        'default_ship_from_location_address' => '\AmazonPHP\SellingPartner\Model\Orders\Address',
        'buyer_invoice_preference' => 'string',
        'buyer_tax_information' => '\AmazonPHP\SellingPartner\Model\Orders\BuyerTaxInformation',
        'fulfillment_instruction' => '\AmazonPHP\SellingPartner\Model\Orders\FulfillmentInstruction',
        'is_ispu' => 'bool',
        'is_access_point_order' => 'bool',
        'marketplace_tax_info' => '\AmazonPHP\SellingPartner\Model\Orders\MarketplaceTaxInfo',
        'seller_display_name' => 'string',
        'shipping_address' => '\AmazonPHP\SellingPartner\Model\Orders\Address',
        'buyer_info' => '\AmazonPHP\SellingPartner\Model\Orders\BuyerInfo',
        'automated_shipping_settings' => '\AmazonPHP\SellingPartner\Model\Orders\AutomatedShippingSettings',
        'has_regulated_items' => 'bool',
        'electronic_invoice_status' => '\AmazonPHP\SellingPartner\Model\Orders\ElectronicInvoiceStatus',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'amazon_order_id' => null,
        'seller_order_id' => null,
        'purchase_date' => null,
        'last_update_date' => null,
        'order_status' => null,
        'fulfillment_channel' => null,
        'sales_channel' => null,
        'order_channel' => null,
        'ship_service_level' => null,
        'order_total' => null,
        'number_of_items_shipped' => null,
        'number_of_items_unshipped' => null,
        'payment_execution_detail' => null,
        'payment_method' => null,
        'payment_method_details' => null,
        'marketplace_id' => null,
        'shipment_service_level_category' => null,
        'easy_ship_shipment_status' => null,
        'cba_displayable_shipping_label' => null,
        'order_type' => null,
        'earliest_ship_date' => null,
        'latest_ship_date' => null,
        'earliest_delivery_date' => null,
        'latest_delivery_date' => null,
        'is_business_order' => null,
        'is_prime' => null,
        'is_premium_order' => null,
        'is_global_express_enabled' => null,
        'replaced_order_id' => null,
        'is_replacement_order' => null,
        'promise_response_due_date' => null,
        'is_estimated_ship_date_set' => null,
        'is_sold_by_ab' => null,
        'is_iba' => null,
        'default_ship_from_location_address' => null,
        'buyer_invoice_preference' => null,
        'buyer_tax_information' => null,
        'fulfillment_instruction' => null,
        'is_ispu' => null,
        'is_access_point_order' => null,
        'marketplace_tax_info' => null,
        'seller_display_name' => null,
        'shipping_address' => null,
        'buyer_info' => null,
        'automated_shipping_settings' => null,
        'has_regulated_items' => null,
        'electronic_invoice_status' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'amazon_order_id' => 'AmazonOrderId',
        'seller_order_id' => 'SellerOrderId',
        'purchase_date' => 'PurchaseDate',
        'last_update_date' => 'LastUpdateDate',
        'order_status' => 'OrderStatus',
        'fulfillment_channel' => 'FulfillmentChannel',
        'sales_channel' => 'SalesChannel',
        'order_channel' => 'OrderChannel',
        'ship_service_level' => 'ShipServiceLevel',
        'order_total' => 'OrderTotal',
        'number_of_items_shipped' => 'NumberOfItemsShipped',
        'number_of_items_unshipped' => 'NumberOfItemsUnshipped',
        'payment_execution_detail' => 'PaymentExecutionDetail',
        'payment_method' => 'PaymentMethod',
        'payment_method_details' => 'PaymentMethodDetails',
        'marketplace_id' => 'MarketplaceId',
        'shipment_service_level_category' => 'ShipmentServiceLevelCategory',
        'easy_ship_shipment_status' => 'EasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'CbaDisplayableShippingLabel',
        'order_type' => 'OrderType',
        'earliest_ship_date' => 'EarliestShipDate',
        'latest_ship_date' => 'LatestShipDate',
        'earliest_delivery_date' => 'EarliestDeliveryDate',
        'latest_delivery_date' => 'LatestDeliveryDate',
        'is_business_order' => 'IsBusinessOrder',
        'is_prime' => 'IsPrime',
        'is_premium_order' => 'IsPremiumOrder',
        'is_global_express_enabled' => 'IsGlobalExpressEnabled',
        'replaced_order_id' => 'ReplacedOrderId',
        'is_replacement_order' => 'IsReplacementOrder',
        'promise_response_due_date' => 'PromiseResponseDueDate',
        'is_estimated_ship_date_set' => 'IsEstimatedShipDateSet',
        'is_sold_by_ab' => 'IsSoldByAB',
        'is_iba' => 'IsIBA',
        'default_ship_from_location_address' => 'DefaultShipFromLocationAddress',
        'buyer_invoice_preference' => 'BuyerInvoicePreference',
        'buyer_tax_information' => 'BuyerTaxInformation',
        'fulfillment_instruction' => 'FulfillmentInstruction',
        'is_ispu' => 'IsISPU',
        'is_access_point_order' => 'IsAccessPointOrder',
        'marketplace_tax_info' => 'MarketplaceTaxInfo',
        'seller_display_name' => 'SellerDisplayName',
        'shipping_address' => 'ShippingAddress',
        'buyer_info' => 'BuyerInfo',
        'automated_shipping_settings' => 'AutomatedShippingSettings',
        'has_regulated_items' => 'HasRegulatedItems',
        'electronic_invoice_status' => 'ElectronicInvoiceStatus',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'amazon_order_id' => 'setAmazonOrderId',
        'seller_order_id' => 'setSellerOrderId',
        'purchase_date' => 'setPurchaseDate',
        'last_update_date' => 'setLastUpdateDate',
        'order_status' => 'setOrderStatus',
        'fulfillment_channel' => 'setFulfillmentChannel',
        'sales_channel' => 'setSalesChannel',
        'order_channel' => 'setOrderChannel',
        'ship_service_level' => 'setShipServiceLevel',
        'order_total' => 'setOrderTotal',
        'number_of_items_shipped' => 'setNumberOfItemsShipped',
        'number_of_items_unshipped' => 'setNumberOfItemsUnshipped',
        'payment_execution_detail' => 'setPaymentExecutionDetail',
        'payment_method' => 'setPaymentMethod',
        'payment_method_details' => 'setPaymentMethodDetails',
        'marketplace_id' => 'setMarketplaceId',
        'shipment_service_level_category' => 'setShipmentServiceLevelCategory',
        'easy_ship_shipment_status' => 'setEasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'setCbaDisplayableShippingLabel',
        'order_type' => 'setOrderType',
        'earliest_ship_date' => 'setEarliestShipDate',
        'latest_ship_date' => 'setLatestShipDate',
        'earliest_delivery_date' => 'setEarliestDeliveryDate',
        'latest_delivery_date' => 'setLatestDeliveryDate',
        'is_business_order' => 'setIsBusinessOrder',
        'is_prime' => 'setIsPrime',
        'is_premium_order' => 'setIsPremiumOrder',
        'is_global_express_enabled' => 'setIsGlobalExpressEnabled',
        'replaced_order_id' => 'setReplacedOrderId',
        'is_replacement_order' => 'setIsReplacementOrder',
        'promise_response_due_date' => 'setPromiseResponseDueDate',
        'is_estimated_ship_date_set' => 'setIsEstimatedShipDateSet',
        'is_sold_by_ab' => 'setIsSoldByAb',
        'is_iba' => 'setIsIba',
        'default_ship_from_location_address' => 'setDefaultShipFromLocationAddress',
        'buyer_invoice_preference' => 'setBuyerInvoicePreference',
        'buyer_tax_information' => 'setBuyerTaxInformation',
        'fulfillment_instruction' => 'setFulfillmentInstruction',
        'is_ispu' => 'setIsIspu',
        'is_access_point_order' => 'setIsAccessPointOrder',
        'marketplace_tax_info' => 'setMarketplaceTaxInfo',
        'seller_display_name' => 'setSellerDisplayName',
        'shipping_address' => 'setShippingAddress',
        'buyer_info' => 'setBuyerInfo',
        'automated_shipping_settings' => 'setAutomatedShippingSettings',
        'has_regulated_items' => 'setHasRegulatedItems',
        'electronic_invoice_status' => 'setElectronicInvoiceStatus',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'amazon_order_id' => 'getAmazonOrderId',
        'seller_order_id' => 'getSellerOrderId',
        'purchase_date' => 'getPurchaseDate',
        'last_update_date' => 'getLastUpdateDate',
        'order_status' => 'getOrderStatus',
        'fulfillment_channel' => 'getFulfillmentChannel',
        'sales_channel' => 'getSalesChannel',
        'order_channel' => 'getOrderChannel',
        'ship_service_level' => 'getShipServiceLevel',
        'order_total' => 'getOrderTotal',
        'number_of_items_shipped' => 'getNumberOfItemsShipped',
        'number_of_items_unshipped' => 'getNumberOfItemsUnshipped',
        'payment_execution_detail' => 'getPaymentExecutionDetail',
        'payment_method' => 'getPaymentMethod',
        'payment_method_details' => 'getPaymentMethodDetails',
        'marketplace_id' => 'getMarketplaceId',
        'shipment_service_level_category' => 'getShipmentServiceLevelCategory',
        'easy_ship_shipment_status' => 'getEasyShipShipmentStatus',
        'cba_displayable_shipping_label' => 'getCbaDisplayableShippingLabel',
        'order_type' => 'getOrderType',
        'earliest_ship_date' => 'getEarliestShipDate',
        'latest_ship_date' => 'getLatestShipDate',
        'earliest_delivery_date' => 'getEarliestDeliveryDate',
        'latest_delivery_date' => 'getLatestDeliveryDate',
        'is_business_order' => 'getIsBusinessOrder',
        'is_prime' => 'getIsPrime',
        'is_premium_order' => 'getIsPremiumOrder',
        'is_global_express_enabled' => 'getIsGlobalExpressEnabled',
        'replaced_order_id' => 'getReplacedOrderId',
        'is_replacement_order' => 'getIsReplacementOrder',
        'promise_response_due_date' => 'getPromiseResponseDueDate',
        'is_estimated_ship_date_set' => 'getIsEstimatedShipDateSet',
        'is_sold_by_ab' => 'getIsSoldByAb',
        'is_iba' => 'getIsIba',
        'default_ship_from_location_address' => 'getDefaultShipFromLocationAddress',
        'buyer_invoice_preference' => 'getBuyerInvoicePreference',
        'buyer_tax_information' => 'getBuyerTaxInformation',
        'fulfillment_instruction' => 'getFulfillmentInstruction',
        'is_ispu' => 'getIsIspu',
        'is_access_point_order' => 'getIsAccessPointOrder',
        'marketplace_tax_info' => 'getMarketplaceTaxInfo',
        'seller_display_name' => 'getSellerDisplayName',
        'shipping_address' => 'getShippingAddress',
        'buyer_info' => 'getBuyerInfo',
        'automated_shipping_settings' => 'getAutomatedShippingSettings',
        'has_regulated_items' => 'getHasRegulatedItems',
        'electronic_invoice_status' => 'getElectronicInvoiceStatus',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['amazon_order_id'] = $data['amazon_order_id'] ?? null;
        $this->container['seller_order_id'] = $data['seller_order_id'] ?? null;
        $this->container['purchase_date'] = $data['purchase_date'] ?? null;
        $this->container['last_update_date'] = $data['last_update_date'] ?? null;
        $this->container['order_status'] = $data['order_status'] ?? null;
        $this->container['fulfillment_channel'] = $data['fulfillment_channel'] ?? null;
        $this->container['sales_channel'] = $data['sales_channel'] ?? null;
        $this->container['order_channel'] = $data['order_channel'] ?? null;
        $this->container['ship_service_level'] = $data['ship_service_level'] ?? null;
        $this->container['order_total'] = $data['order_total'] ?? null;
        $this->container['number_of_items_shipped'] = $data['number_of_items_shipped'] ?? null;
        $this->container['number_of_items_unshipped'] = $data['number_of_items_unshipped'] ?? null;
        $this->container['payment_execution_detail'] = $data['payment_execution_detail'] ?? null;
        $this->container['payment_method'] = $data['payment_method'] ?? null;
        $this->container['payment_method_details'] = $data['payment_method_details'] ?? null;
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['shipment_service_level_category'] = $data['shipment_service_level_category'] ?? null;
        $this->container['easy_ship_shipment_status'] = $data['easy_ship_shipment_status'] ?? null;
        $this->container['cba_displayable_shipping_label'] = $data['cba_displayable_shipping_label'] ?? null;
        $this->container['order_type'] = $data['order_type'] ?? null;
        $this->container['earliest_ship_date'] = $data['earliest_ship_date'] ?? null;
        $this->container['latest_ship_date'] = $data['latest_ship_date'] ?? null;
        $this->container['earliest_delivery_date'] = $data['earliest_delivery_date'] ?? null;
        $this->container['latest_delivery_date'] = $data['latest_delivery_date'] ?? null;
        $this->container['is_business_order'] = $data['is_business_order'] ?? null;
        $this->container['is_prime'] = $data['is_prime'] ?? null;
        $this->container['is_premium_order'] = $data['is_premium_order'] ?? null;
        $this->container['is_global_express_enabled'] = $data['is_global_express_enabled'] ?? null;
        $this->container['replaced_order_id'] = $data['replaced_order_id'] ?? null;
        $this->container['is_replacement_order'] = $data['is_replacement_order'] ?? null;
        $this->container['promise_response_due_date'] = $data['promise_response_due_date'] ?? null;
        $this->container['is_estimated_ship_date_set'] = $data['is_estimated_ship_date_set'] ?? null;
        $this->container['is_sold_by_ab'] = $data['is_sold_by_ab'] ?? null;
        $this->container['is_iba'] = $data['is_iba'] ?? null;
        $this->container['default_ship_from_location_address'] = $data['default_ship_from_location_address'] ?? null;
        $this->container['buyer_invoice_preference'] = $data['buyer_invoice_preference'] ?? null;
        $this->container['buyer_tax_information'] = $data['buyer_tax_information'] ?? null;
        $this->container['fulfillment_instruction'] = $data['fulfillment_instruction'] ?? null;
        $this->container['is_ispu'] = $data['is_ispu'] ?? null;
        $this->container['is_access_point_order'] = $data['is_access_point_order'] ?? null;
        $this->container['marketplace_tax_info'] = $data['marketplace_tax_info'] ?? null;
        $this->container['seller_display_name'] = $data['seller_display_name'] ?? null;
        $this->container['shipping_address'] = $data['shipping_address'] ?? null;
        $this->container['buyer_info'] = $data['buyer_info'] ?? null;
        $this->container['automated_shipping_settings'] = $data['automated_shipping_settings'] ?? null;
        $this->container['has_regulated_items'] = $data['has_regulated_items'] ?? null;
        $this->container['electronic_invoice_status'] = $data['electronic_invoice_status'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getOrderStatusAllowableValues() : array
    {
        return [
            self::ORDER_STATUS_PENDING,
            self::ORDER_STATUS_UNSHIPPED,
            self::ORDER_STATUS_PARTIALLY_SHIPPED,
            self::ORDER_STATUS_SHIPPED,
            self::ORDER_STATUS_CANCELED,
            self::ORDER_STATUS_UNFULFILLABLE,
            self::ORDER_STATUS_INVOICE_UNCONFIRMED,
            self::ORDER_STATUS_PENDING_AVAILABILITY,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getFulfillmentChannelAllowableValues() : array
    {
        return [
            self::FULFILLMENT_CHANNEL_MFN,
            self::FULFILLMENT_CHANNEL_AFN,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getPaymentMethodAllowableValues() : array
    {
        return [
            self::PAYMENT_METHOD_COD,
            self::PAYMENT_METHOD_CVS,
            self::PAYMENT_METHOD_OTHER,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getOrderTypeAllowableValues() : array
    {
        return [
            self::ORDER_TYPE_STANDARD_ORDER,
            self::ORDER_TYPE_LONG_LEAD_TIME_ORDER,
            self::ORDER_TYPE_PREORDER,
            self::ORDER_TYPE_BACK_ORDER,
            self::ORDER_TYPE_SOURCING_ON_DEMAND_ORDER,
        ];
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public function getBuyerInvoicePreferenceAllowableValues() : array
    {
        return [
            self::BUYER_INVOICE_PREFERENCE_INDIVIDUAL,
            self::BUYER_INVOICE_PREFERENCE_BUSINESS,
        ];
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['amazon_order_id'] === null) {
            throw new AssertionException("'amazon_order_id' can't be null");
        }

        if ($this->container['purchase_date'] === null) {
            throw new AssertionException("'purchase_date' can't be null");
        }

        if ($this->container['last_update_date'] === null) {
            throw new AssertionException("'last_update_date' can't be null");
        }

        if ($this->container['order_status'] === null) {
            throw new AssertionException("'order_status' can't be null");
        }

        $allowedValues = $this->getOrderStatusAllowableValues();

        if (null !== $this->container['order_status'] && !\in_array($this->container['order_status'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'order_status', must be one of '%s'",
                    $this->container['order_status'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        $allowedValues = $this->getFulfillmentChannelAllowableValues();

        if (null !== $this->container['fulfillment_channel'] && !\in_array($this->container['fulfillment_channel'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'fulfillment_channel', must be one of '%s'",
                    $this->container['fulfillment_channel'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['order_total'] !== null) {
            $this->container['order_total']->validate();
        }

        $allowedValues = $this->getPaymentMethodAllowableValues();

        if (null !== $this->container['payment_method'] && !\in_array($this->container['payment_method'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'payment_method', must be one of '%s'",
                    $this->container['payment_method'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        $allowedValues = $this->getOrderTypeAllowableValues();

        if (null !== $this->container['order_type'] && !\in_array($this->container['order_type'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'order_type', must be one of '%s'",
                    $this->container['order_type'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['default_ship_from_location_address'] !== null) {
            $this->container['default_ship_from_location_address']->validate();
        }

        $allowedValues = $this->getBuyerInvoicePreferenceAllowableValues();

        if (null !== $this->container['buyer_invoice_preference'] && !\in_array($this->container['buyer_invoice_preference'], $allowedValues, true)) {
            throw new AssertionException(
                \sprintf(
                    "invalid value '%s' for 'buyer_invoice_preference', must be one of '%s'",
                    $this->container['buyer_invoice_preference'],
                    \implode("', '", $allowedValues)
                )
            );
        }

        if ($this->container['buyer_tax_information'] !== null) {
            $this->container['buyer_tax_information']->validate();
        }

        if ($this->container['fulfillment_instruction'] !== null) {
            $this->container['fulfillment_instruction']->validate();
        }

        if ($this->container['marketplace_tax_info'] !== null) {
            $this->container['marketplace_tax_info']->validate();
        }

        if ($this->container['shipping_address'] !== null) {
            $this->container['shipping_address']->validate();
        }

        if ($this->container['buyer_info'] !== null) {
            $this->container['buyer_info']->validate();
        }

        if ($this->container['automated_shipping_settings'] !== null) {
            $this->container['automated_shipping_settings']->validate();
        }
    }

    /**
     * Gets amazon_order_id.
     */
    public function getAmazonOrderId() : string
    {
        return $this->container['amazon_order_id'];
    }

    /**
     * Sets amazon_order_id.
     *
     * @param string $amazon_order_id an Amazon-defined order identifier, in 3-7-7 format
     */
    public function setAmazonOrderId(string $amazon_order_id) : self
    {
        $this->container['amazon_order_id'] = $amazon_order_id;

        return $this;
    }

    /**
     * Gets seller_order_id.
     */
    public function getSellerOrderId() : ?string
    {
        return $this->container['seller_order_id'];
    }

    /**
     * Sets seller_order_id.
     *
     * @param null|string $seller_order_id a seller-defined order identifier
     */
    public function setSellerOrderId(?string $seller_order_id) : self
    {
        $this->container['seller_order_id'] = $seller_order_id;

        return $this;
    }

    /**
     * Gets purchase_date.
     */
    public function getPurchaseDate() : string
    {
        return $this->container['purchase_date'];
    }

    /**
     * Sets purchase_date.
     *
     * @param string $purchase_date the date when the order was created
     */
    public function setPurchaseDate(string $purchase_date) : self
    {
        $this->container['purchase_date'] = $purchase_date;

        return $this;
    }

    /**
     * Gets last_update_date.
     */
    public function getLastUpdateDate() : string
    {
        return $this->container['last_update_date'];
    }

    /**
     * Sets last_update_date.
     *
     * @param string $last_update_date The date when the order was last updated.  __Note__: `LastUpdateDate` is returned with an incorrect date for orders that were last updated before 2009-04-01.
     */
    public function setLastUpdateDate(string $last_update_date) : self
    {
        $this->container['last_update_date'] = $last_update_date;

        return $this;
    }

    /**
     * Gets order_status.
     */
    public function getOrderStatus() : string
    {
        return $this->container['order_status'];
    }

    /**
     * Sets order_status.
     *
     * @param string $order_status the current order status
     */
    public function setOrderStatus(string $order_status) : self
    {
        $this->container['order_status'] = $order_status;

        return $this;
    }

    /**
     * Gets fulfillment_channel.
     */
    public function getFulfillmentChannel() : ?string
    {
        return $this->container['fulfillment_channel'];
    }

    /**
     * Sets fulfillment_channel.
     *
     * @param null|string $fulfillment_channel whether the order was fulfilled by Amazon (`AFN`) or by the seller (`MFN`)
     */
    public function setFulfillmentChannel(?string $fulfillment_channel) : self
    {
        $this->container['fulfillment_channel'] = $fulfillment_channel;

        return $this;
    }

    /**
     * Gets sales_channel.
     */
    public function getSalesChannel() : ?string
    {
        return $this->container['sales_channel'];
    }

    /**
     * Sets sales_channel.
     *
     * @param null|string $sales_channel the sales channel for the first item in the order
     */
    public function setSalesChannel(?string $sales_channel) : self
    {
        $this->container['sales_channel'] = $sales_channel;

        return $this;
    }

    /**
     * Gets order_channel.
     */
    public function getOrderChannel() : ?string
    {
        return $this->container['order_channel'];
    }

    /**
     * Sets order_channel.
     *
     * @param null|string $order_channel the order channel for the first item in the order
     */
    public function setOrderChannel(?string $order_channel) : self
    {
        $this->container['order_channel'] = $order_channel;

        return $this;
    }

    /**
     * Gets ship_service_level.
     */
    public function getShipServiceLevel() : ?string
    {
        return $this->container['ship_service_level'];
    }

    /**
     * Sets ship_service_level.
     *
     * @param null|string $ship_service_level the order's shipment service level
     */
    public function setShipServiceLevel(?string $ship_service_level) : self
    {
        $this->container['ship_service_level'] = $ship_service_level;

        return $this;
    }

    /**
     * Gets order_total.
     */
    public function getOrderTotal() : ?Money
    {
        return $this->container['order_total'];
    }

    /**
     * Sets order_total.
     *
     * @param null|Money $order_total order_total
     */
    public function setOrderTotal(?Money $order_total) : self
    {
        $this->container['order_total'] = $order_total;

        return $this;
    }

    /**
     * Gets number_of_items_shipped.
     */
    public function getNumberOfItemsShipped() : ?int
    {
        return $this->container['number_of_items_shipped'];
    }

    /**
     * Sets number_of_items_shipped.
     *
     * @param null|int $number_of_items_shipped the number of items shipped
     */
    public function setNumberOfItemsShipped(?int $number_of_items_shipped) : self
    {
        $this->container['number_of_items_shipped'] = $number_of_items_shipped;

        return $this;
    }

    /**
     * Gets number_of_items_unshipped.
     */
    public function getNumberOfItemsUnshipped() : ?int
    {
        return $this->container['number_of_items_unshipped'];
    }

    /**
     * Sets number_of_items_unshipped.
     *
     * @param null|int $number_of_items_unshipped the number of items unshipped
     */
    public function setNumberOfItemsUnshipped(?int $number_of_items_unshipped) : self
    {
        $this->container['number_of_items_unshipped'] = $number_of_items_unshipped;

        return $this;
    }

    /**
     * Gets payment_execution_detail.
     *
     * @return null|PaymentExecutionDetailItem[]
     */
    public function getPaymentExecutionDetail() : ?array
    {
        return $this->container['payment_execution_detail'];
    }

    /**
     * Sets payment_execution_detail.
     *
     * @param null|PaymentExecutionDetailItem[] $payment_execution_detail a list of payment execution detail items
     */
    public function setPaymentExecutionDetail(?array $payment_execution_detail) : self
    {
        $this->container['payment_execution_detail'] = $payment_execution_detail;

        return $this;
    }

    /**
     * Gets payment_method.
     */
    public function getPaymentMethod() : ?string
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method.
     *
     * @param null|string $payment_method The payment method for the order. This property is limited to COD and CVS payment methods. Unless you need the specific COD payment information provided by the `PaymentExecutionDetailItem` object, we recommend using the `PaymentMethodDetails` property to get payment method information.
     */
    public function setPaymentMethod(?string $payment_method) : self
    {
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_method_details.
     *
     * @return null|string[]
     */
    public function getPaymentMethodDetails() : ?array
    {
        return $this->container['payment_method_details'];
    }

    /**
     * Sets payment_method_details.
     *
     * @param null|string[] $payment_method_details a list of payment method detail items
     */
    public function setPaymentMethodDetails(?array $payment_method_details) : self
    {
        $this->container['payment_method_details'] = $payment_method_details;

        return $this;
    }

    /**
     * Gets marketplace_id.
     */
    public function getMarketplaceId() : ?string
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id.
     *
     * @param null|string $marketplace_id the identifier for the marketplace where the order was placed
     */
    public function setMarketplaceId(?string $marketplace_id) : self
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }

    /**
     * Gets shipment_service_level_category.
     */
    public function getShipmentServiceLevelCategory() : ?string
    {
        return $this->container['shipment_service_level_category'];
    }

    /**
     * Sets shipment_service_level_category.
     *
     * @param null|string $shipment_service_level_category The shipment service level category for the order.  **Possible values**: `Expedited`, `FreeEconomy`, `NextDay`, `Priority`, `SameDay`, `SecondDay`, `Scheduled`, and `Standard`.
     */
    public function setShipmentServiceLevelCategory(?string $shipment_service_level_category) : self
    {
        $this->container['shipment_service_level_category'] = $shipment_service_level_category;

        return $this;
    }

    /**
     * Gets easy_ship_shipment_status.
     */
    public function getEasyShipShipmentStatus() : ?EasyShipShipmentStatus
    {
        return $this->container['easy_ship_shipment_status'];
    }

    /**
     * Sets easy_ship_shipment_status.
     *
     * @param null|EasyShipShipmentStatus $easy_ship_shipment_status easy_ship_shipment_status
     */
    public function setEasyShipShipmentStatus(?EasyShipShipmentStatus $easy_ship_shipment_status) : self
    {
        $this->container['easy_ship_shipment_status'] = $easy_ship_shipment_status;

        return $this;
    }

    /**
     * Gets cba_displayable_shipping_label.
     */
    public function getCbaDisplayableShippingLabel() : ?string
    {
        return $this->container['cba_displayable_shipping_label'];
    }

    /**
     * Sets cba_displayable_shipping_label.
     *
     * @param null|string $cba_displayable_shipping_label custom ship label for Checkout by Amazon (CBA)
     */
    public function setCbaDisplayableShippingLabel(?string $cba_displayable_shipping_label) : self
    {
        $this->container['cba_displayable_shipping_label'] = $cba_displayable_shipping_label;

        return $this;
    }

    /**
     * Gets order_type.
     */
    public function getOrderType() : ?string
    {
        return $this->container['order_type'];
    }

    /**
     * Sets order_type.
     *
     * @param null|string $order_type the order's type
     */
    public function setOrderType(?string $order_type) : self
    {
        $this->container['order_type'] = $order_type;

        return $this;
    }

    /**
     * Gets earliest_ship_date.
     */
    public function getEarliestShipDate() : ?string
    {
        return $this->container['earliest_ship_date'];
    }

    /**
     * Sets earliest_ship_date.
     *
     * @param null|string $earliest_ship_date The start of the time period within which you have committed to ship the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders.  __Note__: `EarliestShipDate` might not be returned for orders placed before February 1, 2013.
     */
    public function setEarliestShipDate(?string $earliest_ship_date) : self
    {
        $this->container['earliest_ship_date'] = $earliest_ship_date;

        return $this;
    }

    /**
     * Gets latest_ship_date.
     */
    public function getLatestShipDate() : ?string
    {
        return $this->container['latest_ship_date'];
    }

    /**
     * Sets latest_ship_date.
     *
     * @param null|string $latest_ship_date The end of the time period within which you have committed to ship the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders.  __Note__: `LatestShipDate` might not be returned for orders placed before February 1, 2013.
     */
    public function setLatestShipDate(?string $latest_ship_date) : self
    {
        $this->container['latest_ship_date'] = $latest_ship_date;

        return $this;
    }

    /**
     * Gets earliest_delivery_date.
     */
    public function getEarliestDeliveryDate() : ?string
    {
        return $this->container['earliest_delivery_date'];
    }

    /**
     * Sets earliest_delivery_date.
     *
     * @param null|string $earliest_delivery_date The start of the time period within which you have committed to fulfill the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders.
     */
    public function setEarliestDeliveryDate(?string $earliest_delivery_date) : self
    {
        $this->container['earliest_delivery_date'] = $earliest_delivery_date;

        return $this;
    }

    /**
     * Gets latest_delivery_date.
     */
    public function getLatestDeliveryDate() : ?string
    {
        return $this->container['latest_delivery_date'];
    }

    /**
     * Sets latest_delivery_date.
     *
     * @param null|string $latest_delivery_date The end of the time period within which you have committed to fulfill the order. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date time format. Only returned for seller-fulfilled orders that do not have a `PendingAvailability`, `Pending`, or `Canceled` status.
     */
    public function setLatestDeliveryDate(?string $latest_delivery_date) : self
    {
        $this->container['latest_delivery_date'] = $latest_delivery_date;

        return $this;
    }

    /**
     * Gets is_business_order.
     */
    public function getIsBusinessOrder() : ?bool
    {
        return $this->container['is_business_order'];
    }

    /**
     * Sets is_business_order.
     *
     * @param null|bool $is_business_order When true, the order is an Amazon Business order. An Amazon Business order is an order where the buyer is a Verified Business Buyer.
     */
    public function setIsBusinessOrder(?bool $is_business_order) : self
    {
        $this->container['is_business_order'] = $is_business_order;

        return $this;
    }

    /**
     * Gets is_prime.
     */
    public function getIsPrime() : ?bool
    {
        return $this->container['is_prime'];
    }

    /**
     * Sets is_prime.
     *
     * @param null|bool $is_prime when true, the order is a seller-fulfilled Amazon Prime order
     */
    public function setIsPrime(?bool $is_prime) : self
    {
        $this->container['is_prime'] = $is_prime;

        return $this;
    }

    /**
     * Gets is_premium_order.
     */
    public function getIsPremiumOrder() : ?bool
    {
        return $this->container['is_premium_order'];
    }

    /**
     * Sets is_premium_order.
     *
     * @param null|bool $is_premium_order When true, the order has a Premium Shipping Service Level Agreement. For more information about Premium Shipping orders, refer to \"Premium Shipping Options\" in the Seller Central Help for your marketplace.
     */
    public function setIsPremiumOrder(?bool $is_premium_order) : self
    {
        $this->container['is_premium_order'] = $is_premium_order;

        return $this;
    }

    /**
     * Gets is_global_express_enabled.
     */
    public function getIsGlobalExpressEnabled() : ?bool
    {
        return $this->container['is_global_express_enabled'];
    }

    /**
     * Sets is_global_express_enabled.
     *
     * @param null|bool $is_global_express_enabled when true, the order is a `GlobalExpress` order
     */
    public function setIsGlobalExpressEnabled(?bool $is_global_express_enabled) : self
    {
        $this->container['is_global_express_enabled'] = $is_global_express_enabled;

        return $this;
    }

    /**
     * Gets replaced_order_id.
     */
    public function getReplacedOrderId() : ?string
    {
        return $this->container['replaced_order_id'];
    }

    /**
     * Sets replaced_order_id.
     *
     * @param null|string $replaced_order_id The order ID value for the order that is being replaced. Returned only if IsReplacementOrder = true.
     */
    public function setReplacedOrderId(?string $replaced_order_id) : self
    {
        $this->container['replaced_order_id'] = $replaced_order_id;

        return $this;
    }

    /**
     * Gets is_replacement_order.
     */
    public function getIsReplacementOrder() : ?bool
    {
        return $this->container['is_replacement_order'];
    }

    /**
     * Sets is_replacement_order.
     *
     * @param null|bool $is_replacement_order when true, this is a replacement order
     */
    public function setIsReplacementOrder(?bool $is_replacement_order) : self
    {
        $this->container['is_replacement_order'] = $is_replacement_order;

        return $this;
    }

    /**
     * Gets promise_response_due_date.
     */
    public function getPromiseResponseDueDate() : ?string
    {
        return $this->container['promise_response_due_date'];
    }

    /**
     * Sets promise_response_due_date.
     *
     * @param null|string $promise_response_due_date Indicates the date by which the seller must respond to the buyer with an estimated ship date. Only returned for Sourcing on Demand orders.
     */
    public function setPromiseResponseDueDate(?string $promise_response_due_date) : self
    {
        $this->container['promise_response_due_date'] = $promise_response_due_date;

        return $this;
    }

    /**
     * Gets is_estimated_ship_date_set.
     */
    public function getIsEstimatedShipDateSet() : ?bool
    {
        return $this->container['is_estimated_ship_date_set'];
    }

    /**
     * Sets is_estimated_ship_date_set.
     *
     * @param null|bool $is_estimated_ship_date_set When true, the estimated ship date is set for the order. Only returned for Sourcing on Demand orders.
     */
    public function setIsEstimatedShipDateSet(?bool $is_estimated_ship_date_set) : self
    {
        $this->container['is_estimated_ship_date_set'] = $is_estimated_ship_date_set;

        return $this;
    }

    /**
     * Gets is_sold_by_ab.
     */
    public function getIsSoldByAb() : ?bool
    {
        return $this->container['is_sold_by_ab'];
    }

    /**
     * Sets is_sold_by_ab.
     *
     * @param null|bool $is_sold_by_ab When true, the item within this order was bought and re-sold by Amazon Business EU SARL (ABEU). By buying and instantly re-selling your items, ABEU becomes the seller of record, making your inventory available for sale to customers who would not otherwise purchase from a third-party seller.
     */
    public function setIsSoldByAb(?bool $is_sold_by_ab) : self
    {
        $this->container['is_sold_by_ab'] = $is_sold_by_ab;

        return $this;
    }

    /**
     * Gets is_iba.
     */
    public function getIsIba() : ?bool
    {
        return $this->container['is_iba'];
    }

    /**
     * Sets is_iba.
     *
     * @param null|bool $is_iba When true, the item within this order was bought and re-sold by Amazon Business EU SARL (ABEU). By buying and instantly re-selling your items, ABEU becomes the seller of record, making your inventory available for sale to customers who would not otherwise purchase from a third-party seller.
     */
    public function setIsIba(?bool $is_iba) : self
    {
        $this->container['is_iba'] = $is_iba;

        return $this;
    }

    /**
     * Gets default_ship_from_location_address.
     */
    public function getDefaultShipFromLocationAddress() : ?Address
    {
        return $this->container['default_ship_from_location_address'];
    }

    /**
     * Sets default_ship_from_location_address.
     *
     * @param null|Address $default_ship_from_location_address default_ship_from_location_address
     */
    public function setDefaultShipFromLocationAddress(?Address $default_ship_from_location_address) : self
    {
        $this->container['default_ship_from_location_address'] = $default_ship_from_location_address;

        return $this;
    }

    /**
     * Gets buyer_invoice_preference.
     */
    public function getBuyerInvoicePreference() : ?string
    {
        return $this->container['buyer_invoice_preference'];
    }

    /**
     * Sets buyer_invoice_preference.
     *
     * @param null|string $buyer_invoice_preference The buyer's invoicing preference. Sellers can use this data to issue electronic invoices for orders in Turkey.  **Note**: This attribute is only available in the Turkey marketplace.
     */
    public function setBuyerInvoicePreference(?string $buyer_invoice_preference) : self
    {
        $this->container['buyer_invoice_preference'] = $buyer_invoice_preference;

        return $this;
    }

    /**
     * Gets buyer_tax_information.
     */
    public function getBuyerTaxInformation() : ?BuyerTaxInformation
    {
        return $this->container['buyer_tax_information'];
    }

    /**
     * Sets buyer_tax_information.
     *
     * @param null|BuyerTaxInformation $buyer_tax_information buyer_tax_information
     */
    public function setBuyerTaxInformation(?BuyerTaxInformation $buyer_tax_information) : self
    {
        $this->container['buyer_tax_information'] = $buyer_tax_information;

        return $this;
    }

    /**
     * Gets fulfillment_instruction.
     */
    public function getFulfillmentInstruction() : ?FulfillmentInstruction
    {
        return $this->container['fulfillment_instruction'];
    }

    /**
     * Sets fulfillment_instruction.
     *
     * @param null|FulfillmentInstruction $fulfillment_instruction fulfillment_instruction
     */
    public function setFulfillmentInstruction(?FulfillmentInstruction $fulfillment_instruction) : self
    {
        $this->container['fulfillment_instruction'] = $fulfillment_instruction;

        return $this;
    }

    /**
     * Gets is_ispu.
     */
    public function getIsIspu() : ?bool
    {
        return $this->container['is_ispu'];
    }

    /**
     * Sets is_ispu.
     *
     * @param null|bool $is_ispu when true, this order is marked to be picked up from a store rather than delivered
     */
    public function setIsIspu(?bool $is_ispu) : self
    {
        $this->container['is_ispu'] = $is_ispu;

        return $this;
    }

    /**
     * Gets is_access_point_order.
     */
    public function getIsAccessPointOrder() : ?bool
    {
        return $this->container['is_access_point_order'];
    }

    /**
     * Sets is_access_point_order.
     *
     * @param null|bool $is_access_point_order When true, this order is marked to be delivered to an Access Point. The access location is chosen by the customer. Access Points include Amazon Hub Lockers, Amazon Hub Counters, and pickup points operated by carriers.
     */
    public function setIsAccessPointOrder(?bool $is_access_point_order) : self
    {
        $this->container['is_access_point_order'] = $is_access_point_order;

        return $this;
    }

    /**
     * Gets marketplace_tax_info.
     */
    public function getMarketplaceTaxInfo() : ?MarketplaceTaxInfo
    {
        return $this->container['marketplace_tax_info'];
    }

    /**
     * Sets marketplace_tax_info.
     *
     * @param null|MarketplaceTaxInfo $marketplace_tax_info marketplace_tax_info
     */
    public function setMarketplaceTaxInfo(?MarketplaceTaxInfo $marketplace_tax_info) : self
    {
        $this->container['marketplace_tax_info'] = $marketplace_tax_info;

        return $this;
    }

    /**
     * Gets seller_display_name.
     */
    public function getSellerDisplayName() : ?string
    {
        return $this->container['seller_display_name'];
    }

    /**
     * Sets seller_display_name.
     *
     * @param null|string $seller_display_name The seller’s friendly name registered in the marketplace where the sale took place. Sellers can use this data to issue electronic invoices for orders in Brazil.  **Note**: This attribute is only available in the Brazil marketplace for the orders with `Pending` or `Unshipped` status.
     */
    public function setSellerDisplayName(?string $seller_display_name) : self
    {
        $this->container['seller_display_name'] = $seller_display_name;

        return $this;
    }

    /**
     * Gets shipping_address.
     */
    public function getShippingAddress() : ?Address
    {
        return $this->container['shipping_address'];
    }

    /**
     * Sets shipping_address.
     *
     * @param null|Address $shipping_address shipping_address
     */
    public function setShippingAddress(?Address $shipping_address) : self
    {
        $this->container['shipping_address'] = $shipping_address;

        return $this;
    }

    /**
     * Gets buyer_info.
     */
    public function getBuyerInfo() : ?BuyerInfo
    {
        return $this->container['buyer_info'];
    }

    /**
     * Sets buyer_info.
     *
     * @param null|BuyerInfo $buyer_info buyer_info
     */
    public function setBuyerInfo(?BuyerInfo $buyer_info) : self
    {
        $this->container['buyer_info'] = $buyer_info;

        return $this;
    }

    /**
     * Gets automated_shipping_settings.
     */
    public function getAutomatedShippingSettings() : ?AutomatedShippingSettings
    {
        return $this->container['automated_shipping_settings'];
    }

    /**
     * Sets automated_shipping_settings.
     *
     * @param null|AutomatedShippingSettings $automated_shipping_settings automated_shipping_settings
     */
    public function setAutomatedShippingSettings(?AutomatedShippingSettings $automated_shipping_settings) : self
    {
        $this->container['automated_shipping_settings'] = $automated_shipping_settings;

        return $this;
    }

    /**
     * Gets has_regulated_items.
     */
    public function getHasRegulatedItems() : ?bool
    {
        return $this->container['has_regulated_items'];
    }

    /**
     * Sets has_regulated_items.
     *
     * @param null|bool $has_regulated_items whether the order contains regulated items which may require additional approval steps before being fulfilled
     */
    public function setHasRegulatedItems(?bool $has_regulated_items) : self
    {
        $this->container['has_regulated_items'] = $has_regulated_items;

        return $this;
    }

    /**
     * Gets electronic_invoice_status.
     */
    public function getElectronicInvoiceStatus() : ?ElectronicInvoiceStatus
    {
        return $this->container['electronic_invoice_status'];
    }

    /**
     * Sets electronic_invoice_status.
     *
     * @param null|ElectronicInvoiceStatus $electronic_invoice_status electronic_invoice_status
     */
    public function setElectronicInvoiceStatus(?ElectronicInvoiceStatus $electronic_invoice_status) : self
    {
        $this->container['electronic_invoice_status'] = $electronic_invoice_status;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
