<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Orders;

/**
 * Orders v0.
 *
 * Use the Orders Selling Partner API to programmatically retrieve order information. With this API, you can develop fast, flexible, and custom applications to manage order synchronization, perform order research, and create demand-based decision support tools.   _Note:_ For the JP, AU, and SG marketplaces, the Orders API supports orders from 2016 onward. For all other marketplaces, the Orders API supports orders for the last two years (orders older than this don't show up in the response).
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
class EasyShipShipmentStatus
{
    /**
     * Possible values of this enum.
     */
    final public const PENDING_SCHEDULE = 'PendingSchedule';

    final public const PENDING_PICK_UP = 'PendingPickUp';

    final public const PENDING_DROP_OFF = 'PendingDropOff';

    final public const LABEL_CANCELED = 'LabelCanceled';

    final public const PICKED_UP = 'PickedUp';

    final public const DROPPED_OFF = 'DroppedOff';

    final public const AT_ORIGIN_FC = 'AtOriginFC';

    final public const AT_DESTINATION_FC = 'AtDestinationFC';

    final public const DELIVERED = 'Delivered';

    final public const REJECTED_BY_BUYER = 'RejectedByBuyer';

    final public const UNDELIVERABLE = 'Undeliverable';

    final public const RETURNING_TO_SELLER = 'ReturningToSeller';

    final public const RETURNED_TO_SELLER = 'ReturnedToSeller';

    final public const LOST = 'Lost';

    final public const OUT_FOR_DELIVERY = 'OutForDelivery';

    final public const DAMAGED = 'Damaged';

    public function __construct(private readonly string $value)
    {
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public static function getAllowableEnumValues() : array
    {
        return [
            self::PENDING_SCHEDULE,
            self::PENDING_PICK_UP,
            self::PENDING_DROP_OFF,
            self::LABEL_CANCELED,
            self::PICKED_UP,
            self::DROPPED_OFF,
            self::AT_ORIGIN_FC,
            self::AT_DESTINATION_FC,
            self::DELIVERED,
            self::REJECTED_BY_BUYER,
            self::UNDELIVERABLE,
            self::RETURNING_TO_SELLER,
            self::RETURNED_TO_SELLER,
            self::LOST,
            self::OUT_FOR_DELIVERY,
            self::DAMAGED,
        ];
    }

    public function toString() : string
    {
        return $this->value;
    }
}
