<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\MerchantFulfillment;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Merchant Fulfillment.
 *
 * With the Selling Partner API for Merchant Fulfillment, you can build applications that sellers can use to purchase shipping for non-Prime and Prime orders using Amazon's Buy Shipping Services.
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ShippingOfferingFilter implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'ShippingOfferingFilter';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'include_packing_slip_with_label' => 'bool',
        'include_complex_shipping_options' => 'bool',
        'carrier_will_pick_up' => '\AmazonPHP\SellingPartner\Model\MerchantFulfillment\CarrierWillPickUpOption',
        'delivery_experience' => '\AmazonPHP\SellingPartner\Model\MerchantFulfillment\DeliveryExperienceOption',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'include_packing_slip_with_label' => null,
        'include_complex_shipping_options' => null,
        'carrier_will_pick_up' => null,
        'delivery_experience' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'include_packing_slip_with_label' => 'IncludePackingSlipWithLabel',
        'include_complex_shipping_options' => 'IncludeComplexShippingOptions',
        'carrier_will_pick_up' => 'CarrierWillPickUp',
        'delivery_experience' => 'DeliveryExperience',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'include_packing_slip_with_label' => 'setIncludePackingSlipWithLabel',
        'include_complex_shipping_options' => 'setIncludeComplexShippingOptions',
        'carrier_will_pick_up' => 'setCarrierWillPickUp',
        'delivery_experience' => 'setDeliveryExperience',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'include_packing_slip_with_label' => 'getIncludePackingSlipWithLabel',
        'include_complex_shipping_options' => 'getIncludeComplexShippingOptions',
        'carrier_will_pick_up' => 'getCarrierWillPickUp',
        'delivery_experience' => 'getDeliveryExperience',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['include_packing_slip_with_label'] = $data['include_packing_slip_with_label'] ?? null;
        $this->container['include_complex_shipping_options'] = $data['include_complex_shipping_options'] ?? null;
        $this->container['carrier_will_pick_up'] = $data['carrier_will_pick_up'] ?? null;
        $this->container['delivery_experience'] = $data['delivery_experience'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
    }

    /**
     * Gets include_packing_slip_with_label.
     */
    public function getIncludePackingSlipWithLabel() : ?bool
    {
        return $this->container['include_packing_slip_with_label'];
    }

    /**
     * Sets include_packing_slip_with_label.
     *
     * @param null|bool $include_packing_slip_with_label when true, include a packing slip with the label
     */
    public function setIncludePackingSlipWithLabel(?bool $include_packing_slip_with_label) : self
    {
        $this->container['include_packing_slip_with_label'] = $include_packing_slip_with_label;

        return $this;
    }

    /**
     * Gets include_complex_shipping_options.
     */
    public function getIncludeComplexShippingOptions() : ?bool
    {
        return $this->container['include_complex_shipping_options'];
    }

    /**
     * Sets include_complex_shipping_options.
     *
     * @param null|bool $include_complex_shipping_options when true, include complex shipping options
     */
    public function setIncludeComplexShippingOptions(?bool $include_complex_shipping_options) : self
    {
        $this->container['include_complex_shipping_options'] = $include_complex_shipping_options;

        return $this;
    }

    /**
     * Gets carrier_will_pick_up.
     */
    public function getCarrierWillPickUp() : ?CarrierWillPickUpOption
    {
        return $this->container['carrier_will_pick_up'];
    }

    /**
     * Sets carrier_will_pick_up.
     *
     * @param null|CarrierWillPickUpOption $carrier_will_pick_up carrier_will_pick_up
     */
    public function setCarrierWillPickUp(?CarrierWillPickUpOption $carrier_will_pick_up) : self
    {
        $this->container['carrier_will_pick_up'] = $carrier_will_pick_up;

        return $this;
    }

    /**
     * Gets delivery_experience.
     */
    public function getDeliveryExperience() : ?DeliveryExperienceOption
    {
        return $this->container['delivery_experience'];
    }

    /**
     * Sets delivery_experience.
     *
     * @param null|DeliveryExperienceOption $delivery_experience delivery_experience
     */
    public function setDeliveryExperience(?DeliveryExperienceOption $delivery_experience) : self
    {
        $this->container['delivery_experience'] = $delivery_experience;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
