<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInboundV0;

/**
 * Selling Partner API for Fulfillment Inbound.
 *
 * The Selling Partner API for Fulfillment Inbound lets you create applications that create and update inbound shipments of inventory to Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
class BarcodeInstruction
{
    /**
     * Possible values of this enum.
     */
    final public const REQUIRES_FNSKU_LABEL = 'RequiresFNSKULabel';

    final public const CAN_USE_ORIGINAL_BARCODE = 'CanUseOriginalBarcode';

    final public const MUST_PROVIDE_SELLER_SKU = 'MustProvideSellerSKU';

    public function __construct(private readonly string $value)
    {
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public static function getAllowableEnumValues() : array
    {
        return [
            self::REQUIRES_FNSKU_LABEL,
            self::CAN_USE_ORIGINAL_BARCODE,
            self::MUST_PROVIDE_SELLER_SKU,
        ];
    }

    public function toString() : string
    {
        return $this->value;
    }
}
