<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TaxRate implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'TaxRate';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'cess_rate' => 'float',
        'gst_rate' => 'float',
        'tax_type' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'cess_rate' => null,
        'gst_rate' => null,
        'tax_type' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'cess_rate' => 'cessRate',
        'gst_rate' => 'gstRate',
        'tax_type' => 'taxType',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'cess_rate' => 'setCessRate',
        'gst_rate' => 'setGstRate',
        'tax_type' => 'setTaxType',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'cess_rate' => 'getCessRate',
        'gst_rate' => 'getGstRate',
        'tax_type' => 'getTaxType',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['cess_rate'] = $data['cess_rate'] ?? null;
        $this->container['gst_rate'] = $data['gst_rate'] ?? null;
        $this->container['tax_type'] = $data['tax_type'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if (null !== $this->container['tax_type'] && (\mb_strlen((string) $this->container['tax_type']) > 1024)) {
            throw new AssertionException("invalid value for 'tax_type', the character length must be smaller than or equal to 1024.");
        }

        if (null !== $this->container['tax_type'] && (\mb_strlen((string) $this->container['tax_type']) < 1)) {
            throw new AssertionException("invalid value for 'tax_type', the character length must be bigger than or equal to 1.");
        }
    }

    /**
     * Gets cess_rate.
     */
    public function getCessRate() : ?float
    {
        return $this->container['cess_rate'];
    }

    /**
     * Sets cess_rate.
     *
     * @param null|float $cess_rate rate of cess tax
     */
    public function setCessRate(?float $cess_rate) : self
    {
        $this->container['cess_rate'] = $cess_rate;

        return $this;
    }

    /**
     * Gets gst_rate.
     */
    public function getGstRate() : ?float
    {
        return $this->container['gst_rate'];
    }

    /**
     * Sets gst_rate.
     *
     * @param null|float $gst_rate rate of gst tax
     */
    public function setGstRate(?float $gst_rate) : self
    {
        $this->container['gst_rate'] = $gst_rate;

        return $this;
    }

    /**
     * Gets tax_type.
     */
    public function getTaxType() : ?string
    {
        return $this->container['tax_type'];
    }

    /**
     * Sets tax_type.
     *
     * @param null|string $tax_type Type of tax. Possible values: `CGST`, `SGST`, `IGST`, `TOTAL_TAX`.
     */
    public function setTaxType(?string $tax_type) : self
    {
        $this->container['tax_type'] = $tax_type;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
