<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SelfShipAppointmentDetails implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'SelfShipAppointmentDetails';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'appointment_id' => 'float',
        'appointment_slot_time' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\AppointmentSlotTime',
        'appointment_status' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'appointment_id' => null,
        'appointment_slot_time' => null,
        'appointment_status' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'appointment_id' => 'appointmentId',
        'appointment_slot_time' => 'appointmentSlotTime',
        'appointment_status' => 'appointmentStatus',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'appointment_id' => 'setAppointmentId',
        'appointment_slot_time' => 'setAppointmentSlotTime',
        'appointment_status' => 'setAppointmentStatus',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'appointment_id' => 'getAppointmentId',
        'appointment_slot_time' => 'getAppointmentSlotTime',
        'appointment_status' => 'getAppointmentStatus',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['appointment_id'] = $data['appointment_id'] ?? null;
        $this->container['appointment_slot_time'] = $data['appointment_slot_time'] ?? null;
        $this->container['appointment_status'] = $data['appointment_status'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['appointment_slot_time'] !== null) {
            $this->container['appointment_slot_time']->validate();
        }

        if (null !== $this->container['appointment_status'] && (\mb_strlen((string) $this->container['appointment_status']) > 1024)) {
            throw new AssertionException("invalid value for 'appointment_status', the character length must be smaller than or equal to 1024.");
        }

        if (null !== $this->container['appointment_status'] && (\mb_strlen((string) $this->container['appointment_status']) < 1)) {
            throw new AssertionException("invalid value for 'appointment_status', the character length must be bigger than or equal to 1.");
        }
    }

    /**
     * Gets appointment_id.
     */
    public function getAppointmentId() : ?float
    {
        return $this->container['appointment_id'];
    }

    /**
     * Sets appointment_id.
     *
     * @param null|float $appointment_id identifier for appointment
     */
    public function setAppointmentId(?float $appointment_id) : self
    {
        $this->container['appointment_id'] = $appointment_id;

        return $this;
    }

    /**
     * Gets appointment_slot_time.
     */
    public function getAppointmentSlotTime() : ?AppointmentSlotTime
    {
        return $this->container['appointment_slot_time'];
    }

    /**
     * Sets appointment_slot_time.
     *
     * @param null|AppointmentSlotTime $appointment_slot_time appointment_slot_time
     */
    public function setAppointmentSlotTime(?AppointmentSlotTime $appointment_slot_time) : self
    {
        $this->container['appointment_slot_time'] = $appointment_slot_time;

        return $this;
    }

    /**
     * Gets appointment_status.
     */
    public function getAppointmentStatus() : ?string
    {
        return $this->container['appointment_status'];
    }

    /**
     * Sets appointment_status.
     *
     * @param null|string $appointment_status status of the appointment
     */
    public function setAppointmentStatus(?string $appointment_status) : self
    {
        $this->container['appointment_status'] = $appointment_status;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
