<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PackageGroupingInput implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'PackageGroupingInput';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'boxes' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\BoxInput[]',
        'packing_group_id' => 'string',
        'shipment_id' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'boxes' => null,
        'packing_group_id' => null,
        'shipment_id' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'boxes' => 'boxes',
        'packing_group_id' => 'packingGroupId',
        'shipment_id' => 'shipmentId',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'boxes' => 'setBoxes',
        'packing_group_id' => 'setPackingGroupId',
        'shipment_id' => 'setShipmentId',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'boxes' => 'getBoxes',
        'packing_group_id' => 'getPackingGroupId',
        'shipment_id' => 'getShipmentId',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['boxes'] = $data['boxes'] ?? null;
        $this->container['packing_group_id'] = $data['packing_group_id'] ?? null;
        $this->container['shipment_id'] = $data['shipment_id'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['boxes'] === null) {
            throw new AssertionException("'boxes' can't be null");
        }

        if ((\count($this->container['boxes']) > 5000)) {
            throw new AssertionException("invalid value for 'boxes', number of items must be less than or equal to 5000.");
        }

        if ((\count($this->container['boxes']) < 1)) {
            throw new AssertionException("invalid value for 'boxes', number of items must be greater than or equal to 1.");
        }

        if (null !== $this->container['packing_group_id'] && (\mb_strlen((string) $this->container['packing_group_id']) > 38)) {
            throw new AssertionException("invalid value for 'packing_group_id', the character length must be smaller than or equal to 38.");
        }

        if (null !== $this->container['packing_group_id'] && (\mb_strlen((string) $this->container['packing_group_id']) < 38)) {
            throw new AssertionException("invalid value for 'packing_group_id', the character length must be bigger than or equal to 38.");
        }

        if (null !== $this->container['packing_group_id'] && !\preg_match('/^[a-zA-Z0-9-]*$/', (string) $this->container['packing_group_id'])) {
            throw new AssertionException("invalid value for 'packing_group_id', must be conform to the pattern /^[a-zA-Z0-9-]*$/.");
        }

        if (null !== $this->container['shipment_id'] && (\mb_strlen((string) $this->container['shipment_id']) > 38)) {
            throw new AssertionException("invalid value for 'shipment_id', the character length must be smaller than or equal to 38.");
        }

        if (null !== $this->container['shipment_id'] && (\mb_strlen((string) $this->container['shipment_id']) < 38)) {
            throw new AssertionException("invalid value for 'shipment_id', the character length must be bigger than or equal to 38.");
        }

        if (null !== $this->container['shipment_id'] && !\preg_match('/^[a-zA-Z0-9-]*$/', (string) $this->container['shipment_id'])) {
            throw new AssertionException("invalid value for 'shipment_id', must be conform to the pattern /^[a-zA-Z0-9-]*$/.");
        }
    }

    /**
     * Gets boxes.
     *
     * @return BoxInput[]
     */
    public function getBoxes() : array
    {
        return $this->container['boxes'];
    }

    /**
     * Sets boxes.
     *
     * @param BoxInput[] $boxes box level information being provided
     */
    public function setBoxes(array $boxes) : self
    {
        $this->container['boxes'] = $boxes;

        return $this;
    }

    /**
     * Gets packing_group_id.
     */
    public function getPackingGroupId() : ?string
    {
        return $this->container['packing_group_id'];
    }

    /**
     * Sets packing_group_id.
     *
     * @param null|string $packing_group_id The ID of the `packingGroup` that packages are grouped according to. The `PackingGroupId` can only be provided before placement confirmation, and it must belong to the confirmed `PackingOption`. One of `ShipmentId` or `PackingGroupId` must be provided with every request.
     */
    public function setPackingGroupId(?string $packing_group_id) : self
    {
        $this->container['packing_group_id'] = $packing_group_id;

        return $this;
    }

    /**
     * Gets shipment_id.
     */
    public function getShipmentId() : ?string
    {
        return $this->container['shipment_id'];
    }

    /**
     * Sets shipment_id.
     *
     * @param null|string $shipment_id The ID of the shipment that packages are grouped according to. The `ShipmentId` can only be provided after placement confirmation, and the shipment must belong to the confirmed placement option. One of `ShipmentId` or `PackingGroupId` must be provided with every request.
     */
    public function setShipmentId(?string $shipment_id) : self
    {
        $this->container['shipment_id'] = $shipment_id;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
