<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for Transfers.
 *
 * The Selling Partner API for Transfers enables selling partners to retrieve payment methods and initiate payouts for their seller accounts. This API supports the following marketplaces: DE, FR, IT, ES, SE, NL, PL, and BE.
 *
 * The version of the OpenAPI document: 2024-06-01
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PaymentMethodDetails implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'PaymentMethodDetails';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'account_holder_name' => 'string',
        'payment_method_id' => 'string',
        'tail' => 'string',
        'expiry_date' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\ExpiryDate',
        'country_code' => 'string',
        'payment_method_type' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\PaymentMethodType',
        'assignment_type' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\AssignmentType',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'account_holder_name' => null,
        'payment_method_id' => null,
        'tail' => null,
        'expiry_date' => null,
        'country_code' => null,
        'payment_method_type' => null,
        'assignment_type' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'account_holder_name' => 'accountHolderName',
        'payment_method_id' => 'paymentMethodId',
        'tail' => 'tail',
        'expiry_date' => 'expiryDate',
        'country_code' => 'countryCode',
        'payment_method_type' => 'paymentMethodType',
        'assignment_type' => 'assignmentType',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'account_holder_name' => 'setAccountHolderName',
        'payment_method_id' => 'setPaymentMethodId',
        'tail' => 'setTail',
        'expiry_date' => 'setExpiryDate',
        'country_code' => 'setCountryCode',
        'payment_method_type' => 'setPaymentMethodType',
        'assignment_type' => 'setAssignmentType',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'account_holder_name' => 'getAccountHolderName',
        'payment_method_id' => 'getPaymentMethodId',
        'tail' => 'getTail',
        'expiry_date' => 'getExpiryDate',
        'country_code' => 'getCountryCode',
        'payment_method_type' => 'getPaymentMethodType',
        'assignment_type' => 'getAssignmentType',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_holder_name'] = $data['account_holder_name'] ?? null;
        $this->container['payment_method_id'] = $data['payment_method_id'] ?? null;
        $this->container['tail'] = $data['tail'] ?? null;
        $this->container['expiry_date'] = $data['expiry_date'] ?? null;
        $this->container['country_code'] = $data['country_code'] ?? null;
        $this->container['payment_method_type'] = $data['payment_method_type'] ?? null;
        $this->container['assignment_type'] = $data['assignment_type'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['expiry_date'] !== null) {
            $this->container['expiry_date']->validate();
        }
    }

    /**
     * Gets account_holder_name.
     */
    public function getAccountHolderName() : ?string
    {
        return $this->container['account_holder_name'];
    }

    /**
     * Sets account_holder_name.
     *
     * @param null|string $account_holder_name the name of the account holder who is registered for the payment method
     */
    public function setAccountHolderName(?string $account_holder_name) : self
    {
        $this->container['account_holder_name'] = $account_holder_name;

        return $this;
    }

    /**
     * Gets payment_method_id.
     */
    public function getPaymentMethodId() : ?string
    {
        return $this->container['payment_method_id'];
    }

    /**
     * Sets payment_method_id.
     *
     * @param null|string $payment_method_id the payment method identifier
     */
    public function setPaymentMethodId(?string $payment_method_id) : self
    {
        $this->container['payment_method_id'] = $payment_method_id;

        return $this;
    }

    /**
     * Gets tail.
     */
    public function getTail() : ?string
    {
        return $this->container['tail'];
    }

    /**
     * Sets tail.
     *
     * @param null|string $tail the last three or four digits of the payment method
     */
    public function setTail(?string $tail) : self
    {
        $this->container['tail'] = $tail;

        return $this;
    }

    /**
     * Gets expiry_date.
     */
    public function getExpiryDate() : ?ExpiryDate
    {
        return $this->container['expiry_date'];
    }

    /**
     * Sets expiry_date.
     *
     * @param null|ExpiryDate $expiry_date expiry_date
     */
    public function setExpiryDate(?ExpiryDate $expiry_date) : self
    {
        $this->container['expiry_date'] = $expiry_date;

        return $this;
    }

    /**
     * Gets country_code.
     */
    public function getCountryCode() : ?string
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code.
     *
     * @param null|string $country_code The two-letter country code in ISO 3166-1 alpha-2 format. For payment methods in the `card` category, the code is for the country where the card was issued. For payment methods in the `bank account` category, the code is for the country where the account is located.
     */
    public function setCountryCode(?string $country_code) : self
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets payment_method_type.
     */
    public function getPaymentMethodType() : ?PaymentMethodType
    {
        return $this->container['payment_method_type'];
    }

    /**
     * Sets payment_method_type.
     *
     * @param null|PaymentMethodType $payment_method_type payment_method_type
     */
    public function setPaymentMethodType(?PaymentMethodType $payment_method_type) : self
    {
        $this->container['payment_method_type'] = $payment_method_type;

        return $this;
    }

    /**
     * Gets assignment_type.
     */
    public function getAssignmentType() : ?AssignmentType
    {
        return $this->container['assignment_type'];
    }

    /**
     * Sets assignment_type.
     *
     * @param null|AssignmentType $assignment_type assignment_type
     */
    public function setAssignmentType(?AssignmentType $assignment_type) : self
    {
        $this->container['assignment_type'] = $assignment_type;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
