<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for Finances.
 *
 * The Selling Partner API for Finances provides financial information relevant to a seller's business. You can obtain financial events for a given order or date range without having to wait until a statement period closes.
 *
 * The version of the OpenAPI document: 2024-06-19
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Item implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Item';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'description' => 'string',
        'related_identifiers' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions\ItemRelatedIdentifier[]',
        'total_amount' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions\Currency',
        'breakdowns' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions\Breakdown[]',
        'contexts' => '\AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions\Context[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'description' => null,
        'related_identifiers' => null,
        'total_amount' => null,
        'breakdowns' => null,
        'contexts' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'description' => 'description',
        'related_identifiers' => 'relatedIdentifiers',
        'total_amount' => 'totalAmount',
        'breakdowns' => 'breakdowns',
        'contexts' => 'contexts',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'description' => 'setDescription',
        'related_identifiers' => 'setRelatedIdentifiers',
        'total_amount' => 'setTotalAmount',
        'breakdowns' => 'setBreakdowns',
        'contexts' => 'setContexts',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'description' => 'getDescription',
        'related_identifiers' => 'getRelatedIdentifiers',
        'total_amount' => 'getTotalAmount',
        'breakdowns' => 'getBreakdowns',
        'contexts' => 'getContexts',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = $data['description'] ?? null;
        $this->container['related_identifiers'] = $data['related_identifiers'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['breakdowns'] = $data['breakdowns'] ?? null;
        $this->container['contexts'] = $data['contexts'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['total_amount'] !== null) {
            $this->container['total_amount']->validate();
        }
    }

    /**
     * Gets description.
     */
    public function getDescription() : ?string
    {
        return $this->container['description'];
    }

    /**
     * Sets description.
     *
     * @param null|string $description a description of the items in a transaction
     */
    public function setDescription(?string $description) : self
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets related_identifiers.
     *
     * @return null|ItemRelatedIdentifier[]
     */
    public function getRelatedIdentifiers() : ?array
    {
        return $this->container['related_identifiers'];
    }

    /**
     * Sets related_identifiers.
     *
     * @param null|ItemRelatedIdentifier[] $related_identifiers related business identifiers of the item in the transaction
     */
    public function setRelatedIdentifiers(?array $related_identifiers) : self
    {
        $this->container['related_identifiers'] = $related_identifiers;

        return $this;
    }

    /**
     * Gets total_amount.
     */
    public function getTotalAmount() : ?Currency
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount.
     *
     * @param null|Currency $total_amount total_amount
     */
    public function setTotalAmount(?Currency $total_amount) : self
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets breakdowns.
     *
     * @return null|Breakdown[]
     */
    public function getBreakdowns() : ?array
    {
        return $this->container['breakdowns'];
    }

    /**
     * Sets breakdowns.
     *
     * @param null|Breakdown[] $breakdowns a list of breakdowns that provide details on how the total amount is calculated for the transaction
     */
    public function setBreakdowns(?array $breakdowns) : self
    {
        $this->container['breakdowns'] = $breakdowns;

        return $this;
    }

    /**
     * Gets contexts.
     *
     * @return null|Context[]
     */
    public function getContexts() : ?array
    {
        return $this->container['contexts'];
    }

    /**
     * Sets contexts.
     *
     * @param null|Context[] $contexts a list of additional information about the item
     */
    public function setContexts(?array $contexts) : self
    {
        $this->container['contexts'] = $contexts;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
