<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\DefaultApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * The Selling Partner API for Transfers.
 *
 * The Selling Partner API for Transfers enables selling partners to retrieve payment methods and initiate payouts for their seller accounts. This API supports the following marketplaces: DE, FR, IT, ES, SE, NL, PL, and BE.
 *
 * The version of the OpenAPI document: 2024-06-01
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface FinancialTransfersSDKInterface
{
    public const API_NAME = 'FinancialTransfers';

    public const OPERATION_GETPAYMENTMETHODS = 'getPaymentMethods';

    public const OPERATION_GETPAYMENTMETHODS_PATH = '/finances/transfers/2024-06-01/paymentMethods';

    public const OPERATION_INITIATEPAYOUT = 'initiatePayout';

    public const OPERATION_INITIATEPAYOUT_PATH = '/finances/transfers/2024-06-01/payouts';

    /**
     * Operation getPaymentMethods.
     *
     * @param string $marketplace_id The identifier of the marketplace from which you want to retrieve payment methods. For the list of possible marketplace identifiers, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param null|string[] $payment_method_types A comma-separated list of the payment method types you want to include in the response. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getPaymentMethods(AccessToken $accessToken, string $region, string $marketplace_id, ?array $payment_method_types = null) : \AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\GetPaymentMethodsResponse;

    /**
     * Operation initiatePayout.
     *
     * @param \AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\InitiatePayoutRequest $body The request body for the &#x60;initiatePayout&#x60; operation. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function initiatePayout(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\InitiatePayoutRequest $body) : \AmazonPHP\SellingPartner\Model\Finances\FinancialTransfers\InitiatePayoutResponse;
}
