<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\DefaultApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * The Selling Partner API for Finances.
 *
 * The Selling Partner API for Finances provides financial information relevant to a seller's business. You can obtain financial events for a given order or date range without having to wait until a statement period closes.
 *
 * The version of the OpenAPI document: 2024-06-19
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface FinancialTransactionsSDKInterface
{
    public const API_NAME = 'FinancialTransactions';

    public const OPERATION_LISTTRANSACTIONS = 'listTransactions';

    public const OPERATION_LISTTRANSACTIONS_PATH = '/finances/2024-06-19/transactions';

    /**
     * Operation listTransactions.
     *
     * @param \DateTimeInterface $posted_after The response includes financial events posted after (or on) this date. This date must be in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. The date-time must be more than two minutes before the time of the request. (required)
     * @param null|\DateTimeInterface $posted_before The response includes financial events posted before (but not on) this date. This date must be in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.  The date-time must be later than &#x60;PostedAfter&#x60; and more than two minutes before the request was submitted. If &#x60;PostedAfter&#x60; and &#x60;PostedBefore&#x60; are more than 180 days apart, the response is empty.  **Default:** Two minutes before the time of the request. (optional)
     * @param null|string $marketplace_id The ID of the marketplace from which you want to retrieve transactions. (optional)
     * @param null|string $next_token The response includes &#x60;nextToken&#x60; when the number of results exceeds the specified &#x60;pageSize&#x60; value. To get the next page of results, call the operation with this token and include the same arguments as the call that produced the token. To get a complete list, call this operation until &#x60;nextToken&#x60; is null. Note that this operation can return empty pages. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listTransactions(AccessToken $accessToken, string $region, \DateTimeInterface $posted_after, ?\DateTimeInterface $posted_before = null, ?string $marketplace_id = null, ?string $next_token = null) : \AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions\ListTransactionsResponse;
}
