<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\CustomerInvoicesApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * Selling Partner API for Direct Fulfillment Shipping.
 *
 * Use the Selling Partner API for Direct Fulfillment Shipping to access a direct fulfillment vendor's shipping data.
 *
 * The version of the OpenAPI document: 2021-12-28
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface VendorDirectFulfillmentShippingSDKInterface
{
    public const API_NAME = 'VendorDirectFulfillmentShipping';

    public const OPERATION_GETCUSTOMERINVOICE = 'getCustomerInvoice';

    public const OPERATION_GETCUSTOMERINVOICE_PATH = '/vendor/directFulfillment/shipping/2021-12-28/customerInvoices/{purchaseOrderNumber}';

    public const OPERATION_GETCUSTOMERINVOICES = 'getCustomerInvoices';

    public const OPERATION_GETCUSTOMERINVOICES_PATH = '/vendor/directFulfillment/shipping/2021-12-28/customerInvoices';

    /**
     * Operation getCustomerInvoice.
     *
     * getCustomerInvoice
     *
     * @param string $purchase_order_number Purchase order number of the shipment for which to return the invoice. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getCustomerInvoice(AccessToken $accessToken, string $region, string $purchase_order_number) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\CustomerInvoice;

    /**
     * Operation getCustomerInvoices.
     *
     * getCustomerInvoices
     *
     * @param \DateTimeInterface $created_after Orders that became available after this date and time will be included in the result. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. (required)
     * @param \DateTimeInterface $created_before Orders that became available before this date and time will be included in the result. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format. (required)
     * @param null|string $ship_from_party_id The vendor warehouseId for order fulfillment. If not specified, the result will contain orders for all warehouses. (optional)
     * @param null|int $limit The limit to the number of records returned (optional)
     * @param null|string $sort_order Sort ASC or DESC by order creation date. (optional)
     * @param null|string $next_token Used for pagination when there are more orders than the specified result size limit. The token value is returned in the previous API call. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getCustomerInvoices(AccessToken $accessToken, string $region, \DateTimeInterface $created_after, \DateTimeInterface $created_before, ?string $ship_from_party_id = null, ?int $limit = null, ?string $sort_order = null, ?string $next_token = null) : \AmazonPHP\SellingPartner\Model\VendorDirectFulfillmentShipping\CustomerInvoiceList;
}
