<?php

require_once __DIR__ . '/vendor/autoload.php';

use AmazonPHP\SellingPartner\OAuth;
use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\Marketplace;
use AmazonPHP\SellingPartner\Regions;
use AmazonPHP\SellingPartner\SellingPartnerSDK;
use GuzzleHttp\Client as GuzzleClient;
use Nyholm\Psr7\Factory\Psr17Factory;
use Psr\Log\NullLogger;
use AmazonPHP\SellingPartner\Model\ListingsItems\ListingsItemPutRequest;
use AmazonPHP\SellingPartner\Api\DefinitionsApi\ProductTypesDefinitionsSDK;
use AmazonPHP\SellingPartner\Model\ProductTypesDefinitions\ProductTypeDefinition;

// Load configuration
$config = require_once __DIR__ . '/config.php';

// Create HTTP factory and client
$factory = new Psr17Factory();
$client = new GuzzleClient();
$httpFactory = new HttpFactory($factory, $factory);
$logger = new NullLogger(); // Create logger instance

// Create OAuth instance
$oauth = new OAuth(
    $client,
    $httpFactory,
    $configuration = Configuration::forIAMUser(
        $config['lwa_client_id'],
        $config['lwa_client_secret'],
        $config['aws_access_key'],
        $config['aws_secret_key']
    ),
    $logger // Add the logger as the 4th parameter
);

// Exchange refresh token for access token
try {
    $accessToken = $oauth->exchangeRefreshToken($config['refresh_token']);
    echo "Successfully obtained access token\n";
    
    // Initialize the SDK
    $sdk = SellingPartnerSDK::create(
        $client,
        $factory, // Pass the RequestFactoryInterface directly
        $factory, // Pass the StreamFactoryInterface directly
        $configuration,
        $logger
    );
    
    echo "SDK initialized successfully\n";
    $productType = 'LUGGAGE';
    $marketplace_id = 'ATVPDKIKX0DER'; // US marketplace ID

    $attributes = [
        "condition_type" => [
            [
                "value" => "new_new",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_name" => [
            [
                "value" => "Jetstream C1000 S3 GRN 20 Hardside Spinner Carry-On",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "country_of_origin" => [
            [
                "value" => "US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "material" => [
            [
                "value" => "Polycarbonate",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "main_product_image_locator" => [
            [
                "media_location" => "https://m.media-amazon.com/images/I/61T7iWBl0aL._SX679_.jpg",
            ]
        ],
        "merchant_suggested_asin" => [
            [
                "value" => "B07Z49J25K",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "color" => [
            [
                "value" => "Black",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_package_dimensions" => [
            [
                "length" => [
                    "value" => 28,
                    "unit" => "inches"
                ],
                "width" => [
                    "value" => 18,
                    "unit" => "inches"
                ],
                "height" => [
                    "value" => 10,
                    "unit" => "inches"
                ],
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "brand" => [
            [
                "value" => "Adidas",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_package_weight" => [
            [
                "value" => 14.89,
                "unit" => "pounds",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "batteries_required" => [
            [
                "value" => false,
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "product_description" => [
            [
                "value" => "Durable spinner suitcase perfect for travel.",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "supplier_declared_dg_hz_regulation" => [
            [
                "value" => "not_applicable",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "list_price" => [
            [
                "value" => 64.00,
                "currency" => "USD",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "model_name" => [
            [
                "value" => "TM-Spinner-2024",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "style" => [
            [
                "value" => "Modern",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "bullet_point" => [
            [
                "value" => "Lightweight and durable",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ],
            [
                "value" => "360° spinner wheels for smooth movement",
                "language_tag" => "en_US",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "item_type_keyword" => [
            [
                "value" => "spinner-suitcases",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "department" => [
            [
                "value" => "unisex-adult",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ],
        "model_number" => [
            [
                "value" => "TM1001",
                "marketplace_id" => "ATVPDKIKX0DER"
            ]
        ]
    ];
    
    
    $body = new ListingsItemPutRequest([ 
        'product_type' => 'LUGGAGE', 
        'requirements' => 'LISTING', 
        'attributes' => $attributes, 
    ]); 

    $sku = 'NF00CLG3VJN'; 
    $merchant_id = 'A2HDH9PWY7LP2W'; // Replace with your Merchant ID

    $result = $sdk->listingsItems()->putListingsItem( 
        $accessToken, 
        'us-east-1', 
        $merchant_id, 
        $sku, 
        [$marketplace_id], 
        $body, 
        null 
    ); 

    echo "Listing created successfully:\n"; 
    print_r(json_encode($result)); 
    
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}